package com.shipsy.ondemand.riderapp.cache.dao

import com.shipsy.ondemand.riderapp.framework.data.orderhistory.OrdersOfDate
import com.shipsy.ondemand.riderapp.shared.cache.AppDatabaseQueries
import com.shipsy.ondemand.riderapp.shared.cache.OrderHistory

/**
 * Created by Kalpesh Kundanani on 29/08/22
 */
class OrderHistoryDao(private val dbQueries: AppDatabaseQueries) {
    fun insertOrderHistory(order: OrdersOfDate) {
        order.data?.forEach { consignment ->
            dbQueries.insertOrderHistory(
                id = null,
                reference_number = consignment.reference_number,
                date = order.date,
                order_time = consignment.orderTimeAsLong,
                order_number = consignment.order_number ?: "-",
                is_vip = consignment.is_vip,
                rider_score = consignment.rider_score ?: "-",
                customer_name = consignment.customer_name ?: "-",
                customer_address = consignment.location?.customerCompleteAddress ?: "-",
                discount_type = consignment.discount_type ?: "-",
                discount_amount = consignment.discount_amount?.toDoubleOrNull() ?: 0.0,
                payment_mode = consignment.payment_details?.firstOrNull()?.mode ?: "-",
                bill_amount = consignment.payment_details?.firstOrNull()?.value ?: 0.0,
                cod_amount = consignment.cod_amount ?: 0.0,
                is_canceled = consignment.isCanceled,
                event_details = consignment.event_details?.filterNotNull() ?: emptyList(),
                hub_name = consignment.hub_name ?: "",
                hub_code = consignment.hub_code ?: "",
                childOrderNumber = consignment.childOrderNumber,
                orderTags = consignment.orderTags,
                tip = consignment.tip,
                eligiblePayout = consignment.eligible_payout
            )
        }
    }

    fun getOrderByDate(string: String): List<OrderHistory> {
        return dbQueries.getOrdersByDate(string).executeAsList()
    }
}