package com.shipsy.ondemand.riderapp.cache.dao

import com.shipsy.ondemand.riderapp.framework.data.oderdata.OrderData
import com.shipsy.ondemand.riderapp.framework.network.model.login.CurrentOrder
import com.shipsy.ondemand.riderapp.framework.network.model.riderevent.RiderEvent
import com.shipsy.ondemand.riderapp.shared.cache.CurrentOrders
import com.shipsy.ondemand.riderapp.shared.cache.RiderStateEvents

fun CurrentOrders.mapToCurrentOrder(): CurrentOrder {
    return CurrentOrder(
        reference_number = reference_number,
        status = status,
        task_type = task_type,
        is_cod = is_cod,
        cod_amount = cod_amount,
        is_vip = is_vip,
        is_bulk = is_bulk,
        notes = notes,
        payment_details = payment_details,
        pieces_detail = pieces_details,
        order_number = order_number,
        order_type = order_type,
        otp = otp,
        makeline_time = makeline_time,
        final_amount = final_amount,
        order_promise_start_time_ondemand = order_promise_start_time_ondemand,
        ondemand_delivery_promise_mins = ondemand_delivery_promise_mins,
        priority = priority?.toInt(),
        ondemand_discount = ondemand_discount,
        last_updated_at = lastUpdatedAt,
        assign_time = assignTime,
        storage_location = storageLocation,
        hu_details = huDetails,
        location = location,
        tip = tip,
        eligible_payout = eligible_payout,
        order_instructions = order_instructions
    )
}

fun List<CurrentOrders>?.mapToOrderData(): List<OrderData>? {
    if (this == null) return null
    if (this.isEmpty()) return emptyList()
    return this.mapListOrderToCurrentOrder().map { OrderData.fromCurrentOrder(it) }
}

fun List<CurrentOrders>.mapListOrderToCurrentOrder(): List<CurrentOrder> {
    val list = mutableListOf<CurrentOrder>()
    this.forEach {
        list.add(it.mapToCurrentOrder())
    }
    return list
}

fun RiderStateEvents.mapToRiderStateRequest(): RiderEvent {
    return RiderEvent(
        type = type,
        reference_number_array = reference_numbers,
        transaction_id = transaction_id,
        timestamp = timestamp,
        lat = lat ?: 0.0,
        lng = lng ?: 0.0,
        payment_details = payment_details,
        auto_swipe = auto_swipe ?: false,
        discount = discount,
        reason = reason,
        receiver_relation = receiver_relation,
        hu_details = hu_details,
        vehicle_number = vehicle_number,
        skip_vehicle_scan_reason = skip_vehicle_scan_reason,
        pieces_status_detail = pieces_status_detail,
        partial_delivery_reason = partialDeliveryReason
    )
}


fun List<RiderStateEvents>.mapListOrderToRiderEventRequest(): List<RiderEvent> {
    val list = mutableListOf<RiderEvent>()
    this.forEach {
        list.add(it.mapToRiderStateRequest())
    }
    return list
}