package com.shipsy.ondemand.riderapp.cache.adapter

import com.shipsy.ondemand.riderapp.framework.network.model.login.*
import com.shipsy.ondemand.riderapp.framework.network.model.riderevent.Discount
import com.squareup.sqldelight.ColumnAdapter

val reference_numbersAdapter = object : ColumnAdapter<List<String>, String> {
    override fun decode(databaseValue: String): List<String> {
        return databaseValue.split(",").filter { it.isNotEmpty() }
    }

    override fun encode(value: List<String>): String {
        val builder = StringBuilder()
        for (data in value) {
            builder.append("${data},")
        }
        return builder.toString()
    }
}
val payment_detailsAdapter = object : ColumnAdapter<List<PaymentDetails>, String> {
    override fun decode(databaseValue: String): List<PaymentDetails> {
        return databaseValue.convertToObject()
    }

    override fun encode(value: List<PaymentDetails>): String {
        return convertToString(value)
    }
}
val discountAdapter = object : ColumnAdapter<Discount, String> {
    override fun decode(databaseValue: String): Discount {
        return databaseValue.convertToObject()
    }

    override fun encode(value: Discount): String {
        return convertToString(value)
    }
}
val reasonAdapter = object : ColumnAdapter<UndeliveredReason, String> {
    override fun decode(databaseValue: String): UndeliveredReason {
        return databaseValue.convertToObject()
    }

    override fun encode(value: UndeliveredReason): String {
        return convertToString(value)
    }
}
val receiver_relationAdapter = object : ColumnAdapter<RelationData, String> {
    override fun decode(databaseValue: String): RelationData {
        return databaseValue.convertToObject()
    }

    override fun encode(value: RelationData): String {
        return convertToString(value)
    }
}
val hu_detailsAdapter = object : ColumnAdapter<List<HUDetail>, String> {
    override fun decode(databaseValue: String): List<HUDetail> {
        return databaseValue.convertToObject()
    }

    override fun encode(value: List<HUDetail>): String {
        return convertToString(value)
    }
}
val pieces_status_detailAdapter = object : ColumnAdapter<List<PieceDetails>, String> {
    override fun decode(databaseValue: String): List<PieceDetails> {
        return databaseValue.convertToObject()
    }

    override fun encode(value: List<PieceDetails>): String {
        return convertToString(value)
    }
}
val partialDeliveryReasonAdapter = object : ColumnAdapter<UndeliveredReason, String> {
    override fun decode(databaseValue: String): UndeliveredReason {
        return databaseValue.convertToObject()
    }

    override fun encode(value: UndeliveredReason): String {
        return convertToString(value)
    }
}