package com.shipsy.ondemand.riderapp.cache.adapter

import com.shipsy.ondemand.riderapp.framework.data.orderhistory.DominoEventModel
import com.squareup.sqldelight.ColumnAdapter

/**
 * Created by Kalpesh Kundanani on 29/08/22
 */
val event_detailsAdapter = object : ColumnAdapter<List<DominoEventModel>, String> {
    override fun decode(databaseValue: String): List<DominoEventModel> {
        return databaseValue.convertToObject()
    }

    override fun encode(value: List<DominoEventModel>): String {
        return convertToString(value)
    }
}

val orderTagsAdapter = object : ColumnAdapter<List<String>, String> {
    override fun decode(databaseValue: String): List<String> {
        return databaseValue.convertToObject()
    }

    override fun encode(value: List<String>): String {
        return convertToString(value)
    }
}