package com.shipsy.ondemand.riderapp.cache.adapter

import com.shipsy.ondemand.riderapp.framework.network.model.login.*
import com.squareup.sqldelight.ColumnAdapter

val paymentDetailsListAdapter = object : ColumnAdapter<List<PaymentDetails>, String> {
    override fun decode(databaseValue: String): List<PaymentDetails> {
        return databaseValue.convertToObject()
    }

    override fun encode(value: List<PaymentDetails>): String {
        return convertToString(value)
    }
}


val piecesDetailsAdapter = object : ColumnAdapter<List<PieceDetails>, String> {
    override fun decode(databaseValue: String): List<PieceDetails> {
        return databaseValue.convertToObject()
    }

    override fun encode(value: List<PieceDetails>): String {
        return convertToString(value)
    }
}


val ondemandDiscountAdapter = object : ColumnAdapter<OnDemandDiscount, String> {
    override fun decode(databaseValue: String): OnDemandDiscount {
        return databaseValue.convertToObject()
    }

    override fun encode(value: OnDemandDiscount): String {
        return convertToString(value)
    }
}


val huDetailsAdapter = object : ColumnAdapter<List<HUDetail>, String> {
    override fun decode(databaseValue: String): List<HUDetail> {
        return databaseValue.convertToObject()
    }

    override fun encode(value: List<HUDetail>): String {
        return convertToString(value)
    }
}

val locationAdapter = object : ColumnAdapter<Location, String>{
    override fun decode(databaseValue: String): Location {
        return databaseValue.convertToObject()
    }

    override fun encode(value: Location): String {
        return convertToString(value)
    }
}

val order_instructionsAdapter = object : ColumnAdapter<List<String>, String>{
    override fun decode(databaseValue: String): List<String> {
        return databaseValue.split(",").filter { it.isNotEmpty() }
    }

    override fun encode(value: List<String>): String {
        val builder = StringBuilder()
        for (data in value) {
            builder.append("${data},")
        }
        return builder.toString()
    }
}