package com.shipsy.ondemand.riderapp.cache.adapter

import kotlinx.serialization.decodeFromString
import kotlinx.serialization.encodeToString
import kotlinx.serialization.json.Json

inline fun <reified inpuT> convertToString(input: inpuT): String {
    return Json.encodeToString(input)
}


inline fun <reified outPuT> String.convertToObject(): outPuT {
    return Json.decodeFromString(this)
}