package com.shipsy.ondemand.riderapp.cache

import com.shipsy.ondemand.riderapp.cache.adapter.*
import com.shipsy.ondemand.riderapp.cache.dao.CurrentOrdersDao
import com.shipsy.ondemand.riderapp.cache.dao.OrderHistoryDao
import com.shipsy.ondemand.riderapp.cache.dao.RiderStateEventDao
import com.shipsy.ondemand.riderapp.shared.cache.AppDatabase
import com.shipsy.ondemand.riderapp.shared.cache.CurrentOrders
import com.shipsy.ondemand.riderapp.shared.cache.OrderHistory
import com.shipsy.ondemand.riderapp.shared.cache.RiderStateEvents

class Database(databaseDriverFactory: DatabaseDriverFactory) {
    private val database = AppDatabase(
        databaseDriverFactory.createDriver(),
        CurrentOrdersAdapter = CurrentOrders.Adapter(
            payment_detailsAdapter = paymentDetailsListAdapter,
            pieces_detailsAdapter = piecesDetailsAdapter,
            ondemand_discountAdapter = ondemandDiscountAdapter,
            huDetailsAdapter = huDetailsAdapter,
            locationAdapter = locationAdapter,
            order_instructionsAdapter = order_instructionsAdapter
        ),
        RiderStateEventsAdapter = RiderStateEvents.Adapter(
            reference_numbersAdapter = reference_numbersAdapter,
            payment_detailsAdapter = payment_detailsAdapter,
            discountAdapter = discountAdapter,
            reasonAdapter = reasonAdapter,
            receiver_relationAdapter = receiver_relationAdapter,
            hu_detailsAdapter = hu_detailsAdapter,
            pieces_status_detailAdapter = pieces_status_detailAdapter,
            partialDeliveryReasonAdapter = partialDeliveryReasonAdapter
        ),
        OrderHistoryAdapter = OrderHistory.Adapter(
            event_detailsAdapter = event_detailsAdapter,
            orderTagsAdapter = orderTagsAdapter
        )

    )
    private val dbQuery = database.appDatabaseQueries

    val currentOrdersDao = CurrentOrdersDao(dbQuery)
    val riderStateEventDao = RiderStateEventDao(dbQuery)
    val orderHistoryDao = OrderHistoryDao(dbQuery)

    internal fun clearDatabase() {
        dbQuery.transaction {
            dbQuery.removeAllCurrentOrders()
            dbQuery.removeAllRiderStateEvents()
        }
    }


}