package com.shipsy.finance.models.network

import kotlinx.serialization.Serializable

@Serializable
data class PayoutResponse(
    val status: String,
    val success: Boolean?,
    val data: PayoutData?
)

@Serializable
data class PayoutData(
    val payoutType: String? = "",
    val startDate: String? = "",
    val endDate: String? = "",
    val totalAmount: String? = "",
    val breakDown: List<Breakdown>? = listOf(),
    val label : String? = "", // will be null in weekly and daily payout response
    val referenceNumber : String? = "", // only when daily payout response if fetch otherwise null
    val weeks : List<PayoutData>? = listOf(),
    val days : List<PayoutData>? = listOf(),
    val moments : List<PayoutData>? = listOf(),
    // these list will be empty on different calls ,
    // eg. list of days will be empty in monthly payout response ,
    // whereas moments will be null or empty in case of monthly and weekly
)



@Serializable
data class Parameter(
    val id: String? = "",
    val name: String? = "",
    val value: String? = "",
    val dataType: String? = "",
    val showOnApp: Boolean? = false
)