package com.shipsy.finance.models.navigation


sealed class Screen(val route: String) {
    object FinanceScreen : Screen(SCREEN_FINANCE)
    object PayoutScreen : Screen(SCREEN_PAYOUT)
    object OrderLevelPayoutScreen : Screen(SCREEN_ORDER_LEVEL_PAYOUT)

    companion object {
        const val SCREEN_FINANCE = "finance"
        const val SCREEN_PAYOUT = "earnings_incentives"
        const val SCREEN_ORDER_LEVEL_PAYOUT = "order_level"
        const val SCREEN_COD_SETTLEMENT = "cod"
        const val SCREEN_TRANSACTION_HISTORY = "transactional_history"
        const val SCREEN_PERFORMANCE = "performance"
        const val SCREEN = "screen"
    }

}
