package com.shipsy.finance.interactors.usecase.payoutscreen

import com.shipsy.finance.models.network.PayoutData
import com.shipsy.ondemand.core.domain.SuspendingUseCase
import com.shipsy.ondemand.core.framework.network.UseCaseResult

interface FetchRiderPayoutUseCase : SuspendingUseCase<FetchRiderPayoutUseCase.Input, UseCaseResult<PayoutData>> {
    data class Input(
        val month: String,
        val year: String,
        val week: String = "",
        val day: String = "",
        val referenceNumber: String = ""
    )
}