package com.shipsy.finance.interactors.helpers

import com.shipsy.finance.models.network.FinanceData
import com.shipsy.finance.models.network.PayoutData
import com.shipsy.ondemand.core.framework.localstorage.LocalStoreImpl
import com.shipsy.ondemand.riderapp.domain.const.SHARED_PREF_CURRENCY_SYMBOL
import kotlinx.serialization.encodeToString
import kotlinx.serialization.json.Json

fun getEncodedString(list: List<FinanceData>): String {
    return Json.encodeToString(list)
}

fun String.withCurrency(): String {
    val localStore = LocalStoreImpl()
    val symbol = localStore.getValue(SHARED_PREF_CURRENCY_SYMBOL, "₹")
    return "$symbol $this"
}

fun getMockResponse(): PayoutData {
    return PayoutData(
        payoutType = "daily",
        startDate = "2022-09-01",
        endDate = "2022-09-01",
        totalAmount = "3",
        breakDown = listOf(),
        moments = listOf(
            PayoutData(
                startDate = "2022-09-01",
                endDate = "2022-09-01",
                totalAmount = "0.15",
                referenceNumber = "A1",
                label = "A1",
                payoutType = "orderlevel"
            ),
            PayoutData(
                startDate = "2022-09-01",
                endDate = "2022-09-01",
                totalAmount = "0.15",
                referenceNumber = "A2",
                label = "A2",
                payoutType = "orderlevel"
            ),
            PayoutData(
                startDate = "2022-09-01",
                endDate = "2022-09-01",
                totalAmount = "0.15",
                referenceNumber = "A3",
                label = "A3",
                payoutType = "orderlevel"
            )
        )
    )
}