package com.shipsy.finance.domain.usecase.payoutscreen

import com.shipsy.finance.interactors.repository.FinanceModuleRepository
import com.shipsy.finance.interactors.usecase.payoutscreen.FetchRiderPayoutUseCase
import com.shipsy.finance.models.network.PayoutData
import com.shipsy.ondemand.riderapp.firebase.FirebaseEventHandler
import com.shipsy.ondemand.core.framework.network.DisplayType
import com.shipsy.ondemand.core.framework.network.ErrorData
import com.shipsy.ondemand.core.framework.network.UseCaseResult
import com.shipsy.ondemand.core.framework.network.getResult
import com.shipsy.ondemand.riderapp.framework.network.model.BaseResponse

class FetchRiderPayoutUseCaseImpl(
    val repo: FinanceModuleRepository
) : FetchRiderPayoutUseCase {
    override suspend fun invoke(input: FetchRiderPayoutUseCase.Input): UseCaseResult<PayoutData> {
        val res = getResult<BaseResponse<PayoutData?>> {
            repo.getRiderPayout(
                input.month,
                input.year,
                input.week,
                input.day,
                input.referenceNumber
            )
        }
        FirebaseEventHandler.logFunctionEvent(
            "FetchRiderPayoutUseCaseImpl", mapOf(
                "query" to input,
                "result" to res.isSuccess
            )
        )
        if (res.isSuccess) {
            val baseData = res.getOrNull()
            val data = if (baseData != null && baseData.success == true) baseData.data else null
            return if (data != null) {
                UseCaseResult.success(data)
            } else {
                UseCaseResult.failure(
                    ErrorData.GeneralError(
                        isVisible = true,
                        DisplayType.SnackBar("Data appears to be absent for this duration")
                    )
                )
            }
        } else {
            val error = res.getErrorData()
            if (error != null)
                return UseCaseResult.failure(error)
            return UseCaseResult.failure(
                ErrorData.GeneralError(
                    isVisible = true,
                    DisplayType.SnackBar("Some Error Occurred")
                )
            )
        }
    }
}