package com.shipsy.finance.domain.usecase.appsettings

import com.shipsy.finance.constants.SHARED_PREF_FINANCE_SCREEN_DISPLAY_DATA
import com.shipsy.finance.interactors.usecase.appsettings.FinanceDisplayDataConfigUseCase
import com.shipsy.finance.models.network.FinanceData
import com.shipsy.ondemand.core.interactor.LocalStore
import com.shipsy.ondemand.riderapp.firebase.FirebaseEventHandler
import kotlinx.serialization.builtins.ListSerializer
import kotlinx.serialization.json.Json

class FinanceDisplayDataConfigUseCaseImpl(
    val localStore: LocalStore
) : FinanceDisplayDataConfigUseCase {
    override fun invoke(): HashMap<String, FinanceData>? {
        val json = localStore.getValue(SHARED_PREF_FINANCE_SCREEN_DISPLAY_DATA, "")

        FirebaseEventHandler.logFunctionEvent(
            "FinanceDisplayDataConfigUseCaseImpl",
            mapOf("json" to json)
        )

        if (json.isNotBlank()) {
            val data = Json.decodeFromString(ListSerializer(FinanceData.serializer()), json)
            val hashMap = HashMap<String, FinanceData>()
            data.map { financeData ->
                financeData.id?.let { it1 -> hashMap.put(it1, financeData) }
            }
            return hashMap
        }
        return null
    }

}