package com.shipsy.finance.domain.usecase

import com.shipsy.finance.interactors.repository.FinanceModuleRepository
import com.shipsy.finance.interactors.usecase.financescreen.FetchFinanceScreenDataUseCase
import com.shipsy.finance.models.network.FinanceData
import com.shipsy.finance.models.network.FinanceResponse
import com.shipsy.ondemand.core.framework.datetime.DateTime
import com.shipsy.ondemand.core.framework.network.DisplayType
import com.shipsy.ondemand.core.framework.network.ErrorData
import com.shipsy.ondemand.core.framework.network.UseCaseResult
import com.shipsy.ondemand.core.framework.network.getResult
import com.shipsy.ondemand.riderapp.firebase.FirebaseEventHandler
import com.shipsy.ondemand.riderapp.framework.network.model.BaseResponse

class FetchFinanceScreenDataUseCaseImpl(
    private val repo: FinanceModuleRepository
) : FetchFinanceScreenDataUseCase {
    override suspend fun invoke(input: Any): UseCaseResult<List<FinanceData>> {
        val currentMillis = DateTime.currentTimeMillis()
        val date = DateTime.format(currentMillis, "yyyy-MM-dd")
        val res = getResult<BaseResponse<FinanceResponse>> {
            repo.getFinanceScreenData(
                date
            )
        }
        FirebaseEventHandler.logFunctionEvent(
            "FetchFinanceScreenDataUseCaseImpl",
            mapOf("query" to date, "result" to res.isSuccess)
        )
        if (res.isSuccess) {
            val data = res.getOrNull()?.data?.overview
            return if (!data.isNullOrEmpty()) {
                UseCaseResult.success(data)
            } else {
                UseCaseResult.failure(
                    ErrorData.GeneralError(
                        isVisible = true,
                        DisplayType.SnackBar("Data appears to be absent for this screen")
                    )
                )
            }
        } else {
            val error = res.getErrorData()
            if (error != null)
                return UseCaseResult.failure(error)
            return UseCaseResult.failure(
                ErrorData.GeneralError(
                    isVisible = true,
                    DisplayType.SnackBar("Some Error Occurred")
                )
            )
        }
    }
}