package com.shipsy.finance.domain.repository

import com.shipsy.finance.interactors.repository.FinanceModuleRepository
import com.shipsy.finance.models.network.FinanceResponse
import com.shipsy.finance.models.network.PayoutData
import com.shipsy.ondemand.riderapp.framework.network.model.BaseResponse
import com.shipsy.ondemand.riderapp.interactor.NetworkClient

class FinanceModuleRepositoryImpl(
    private val client: NetworkClient
) : FinanceModuleRepository {
    override suspend fun getFinanceScreenData(
        date: String
    ): BaseResponse<FinanceResponse> {
        return client.getFinanceScreenData(date)
    }

    override suspend fun getRiderPayout(
        month: String,
        year: String,
        week: String,
        day: String,
        referenceNumber: String
    ): BaseResponse<PayoutData?> {
        return client.getRiderPayout(month, year, week, day, referenceNumber)
    }
}