package com.shipsy.ondemand.core.framework.network

import com.shipsy.ondemand.core.domain.ADS_ID_NOT_PRESENT
import com.shipsy.ondemand.core.domain.ERROR_WRONG_TIME


fun NetworkError.asErrorData(): ErrorData {
    println("received data in error -> ${this.error}")

    when(error?.reason) {
        ADS_ID_NOT_PRESENT -> return ErrorData.AdsIdNeeded
    }

    return when (error?.statusCode) {
        401 -> ErrorData.Unauthorised(error.message ?: "")
        400 -> ErrorData.GeneralError(displayType = DisplayType.SnackBar(error.message ?: ""))
        403 -> {
            if(error.reason.equals(ERROR_WRONG_TIME, ignoreCase = true)) {
                ErrorData.WrongTime(
                    error = error.popup_title ?: "Wrong Time",
                    message = error.message
                        ?: "Time of your device does not seems to be correct, please set it to current time and retry."
                )
            } else{
                ErrorData.AppUpdate(true, error.message, error.latest_version_code)
            }
        }
        else -> ErrorData.GeneralError(
            isVisible = true,
            displayType = DisplayType.SnackBar(error?.message ?: "")
        )
    }
}