package com.shipsy.ondemand.core.framework.network

sealed class DisplayType(val errorMessage: String) {
    data class Alert(val title: String, val error: String) : DisplayType(error)
    data class SnackBar(val error: String, val displayTime: Long = 0) : DisplayType(error)
    data class Toast(val error: String, val displayTime: Long = 0) : DisplayType(error)
}