package com.shipsy.ondemand.core.framework.network

import kotlinx.serialization.SerialName
import kotlinx.serialization.Serializable

/**
 * @author Atul Sakhala 27-04-2023
 */
@Serializable
data class BaseResponse<T>(
    val status: String? = null,
    val success: Boolean? = null,
    val data: T? = null,
    val paginatedData: PaginatedData?=null
)

@Serializable
data class PaginatedData(
    @SerialName("next_present")
    val isLoadNext:Boolean = false
)
