package com.shipsy.ondemand.core.framework.localstorage

import android.content.Context
import android.content.SharedPreferences
import com.shipsy.ondemand.core.interactor.LocalStoreType

internal class LocalStoreNative(private val context: Context) {
    private val localStore: SharedPreferences by lazy { getLocalStoreInstance() }
    private val localStoreEditor: SharedPreferences.Editor by lazy { getEditableLocalStoreInstance() }

    private fun getLocalStoreInstance(): SharedPreferences {
        return context.getSharedPreferences("shipsy_rider_app", Context.MODE_PRIVATE)
    }


    private fun getEditableLocalStoreInstance(): SharedPreferences.Editor {
        return localStore.edit()
    }

    fun <T> putValue(key: String, value: T) {
        when (value) {
            is String -> localStoreEditor.putString(key, value).commit()
            is Int -> localStoreEditor.putInt(key, value).commit()
            is Float -> localStoreEditor.putFloat(key, value).commit()
            is Double -> localStoreEditor.putString(key, value.toString()).commit()
            is Long -> localStoreEditor.putLong(key, value).commit()
            is Boolean -> localStoreEditor.putBoolean(key, value).commit()
            is Set<*> -> localStoreEditor.putStringSet(key, value as Set<String>).commit()
        }
    }

    fun <T> getValue(key: String, default: T): T {
        return when (default) {
            is String -> localStore.getString(key, default) as T
            is Int -> localStore.getInt(key, default) as T
            is Float -> localStore.getFloat(key, default) as T
            is Double -> localStore.getString(key, default.toString())?.toDouble() as T
            is Long -> localStore.getLong(key, default) as T
            is Boolean -> localStore.getBoolean(key, default) as T
            is Set<*> -> localStore.getStringSet(key, default as Set<String>) as T
            else -> "" as T
        }
    }

    fun clear() {
        localStoreEditor.clear().commit()
    }
}