package com.shipsy.ondemand.core.framework.localstorage

import android.content.Context
import android.content.SharedPreferences
import com.shipsy.ondemand.core.interactor.LocalStore
import com.shipsy.ondemand.core.interactor.LocalStoreType
import org.koin.core.component.KoinComponent
import org.koin.core.component.inject

actual class LocalStoreImpl actual constructor() : KoinComponent,
    LocalStore {
    private val context: Context by inject()
    private val localStoreNative = LocalStoreNative(context)
    override fun <T> putValue(key: String, value: T) {
        localStoreNative.putValue(key, value)
    }

    override fun <T> getValue(key: String, default: T): T {
        return localStoreNative.getValue(key, default)
    }

    override fun clear() {
        localStoreNative.clear()
    }

}