package com.shipsy.ondemand.core.framework.network


class UseCaseResult<out T> private constructor(
    private val value: T? = null,
    internal val error: ErrorData? = null
) {

    /**
     * Returns `true` if this instance represents a successful outcome.
     * In this case [isFailure] returns `false`.
     */
    val isSuccess: Boolean get() = error == null

    /**
     * Returns `true` if this instance represents a failed outcome.
     * In this case [isSuccess] returns `false`.
     */
    val isFailure: Boolean get() = error != null

    fun getOrNull(): T? =
        when {
            isFailure -> null
            else -> value as T
        }


    fun getErrorData(): ErrorData? =
        error


    companion object {
        fun <T> failure(error: ErrorData): UseCaseResult<T> =
            UseCaseResult(error = error)


        fun <T> success(value: T): UseCaseResult<T> =
            UseCaseResult(value)



    }

}
