package com.shipsy.ondemand.core.framework.network

import com.shipsy.ondemand.core.EnvData
import com.shipsy.ondemand.core.Environment
import com.shipsy.ondemand.core.framework.util.JsonHelper
import com.shipsy.ondemand.core.interactor.BaseUrlUseCase
import com.shipsy.ondemand.core.interactor.HeaderProviderUseCase
import com.shipsy.ondemand.core.interactor.RetryEndPoints
import io.ktor.client.*
import io.ktor.client.plugins.*
import io.ktor.client.plugins.contentnegotiation.*
import io.ktor.client.plugins.logging.*
import io.ktor.client.request.*
import io.ktor.http.HttpStatusCode
import io.ktor.serialization.kotlinx.json.*
//import io.shipsy.testingmodule.mocknetwork.MockClient.getMockClient

object NetworkService {
    fun getClient(
        baseUrl: BaseUrlUseCase,
        headerProviderUseCase: HeaderProviderUseCase,
        retryEndPoints: RetryEndPoints
    ): HttpClient {
//        return if (baseUrl.invoke().contains("localhost")) {
//            getMockClient(retryEndPoints.invoke(), headerProviderUseCase.invoke(null))
//        } else {
          return  HttpClient() {
                expectSuccess = true

                engine {
                    threadsCount = 4
                    pipelining = true
                }
                install(ContentNegotiation) {
                    json(JsonHelper.json)
                }

//                install(HttpTimeout) {
//                    requestTimeoutMillis = 60000
//                    connectTimeoutMillis = 60000
//                    socketTimeoutMillis = 60000
//                }

                install(Logging) {
                    logger = Logger.DEFAULT
                    level = LogLevel.ALL
                }

//                install(HttpTimeout) {
//                    requestTimeoutMillis = 120000
//                }

                install(HttpRequestRetry) {
                    maxRetries = 3

                    retryOnExceptionIf { request, cause ->
                        retryEndPoints.invoke().contains(
                            request.url.toString().split("/api/")[1]
                        ) && cause is ClientRequestException &&
                                (cause.response.status == HttpStatusCode.BadGateway
                                        || cause.response.status == HttpStatusCode.GatewayTimeout
                                        || cause.response.status == HttpStatusCode.RequestTimeout)
                    }
                    delayMillis { retry ->
                        retry * 3000L
                    } // retries in 3, 6, 9, etc. seconds
                }

                defaultRequest {
                    url(baseUrl.invoke())
                    headerProviderUseCase.invoke(null).forEach {
                        header(it.key, it.value)
                    }
                }
            }
//        }
    }

}