package com.shipsy.ondemand.core.framework.network

import kotlinx.serialization.Serializable

@Serializable
data class NetworkError(val error: ErrorResponse?) : Throwable()


@Serializable
data class NetworkMockError(val error: ErrorResponse?)
@Serializable
data class ErrorResponse(
    val statusCode //status code same as status
    : Int = 0,
    val message //message to be displayed on UI
    : String?,
    val name // text like "error"
    : String? = null,
    val status //status code 403
    : Int = 0,
    val code // code message like "wrong input"
    : String? = null,
    val popup_title //title of popup to be displayed on UI
    : String? = null,

    val reason //reason of error
    : String? = null,
    val app_link //app link to download for app update
    : String? = null,
    val latest_version_code: Int? = null,
    val min_supported_version_code: Int? = null,
    val app_link_side_load: String? = null,
    val allow_s3_update: Boolean? = null,
)