package com.shipsy.ondemand.core.framework.network

import kotlinx.serialization.SerialName
import kotlinx.serialization.Serializable

sealed class ErrorData {

    data class GeneralError(
        val isVisible: Boolean = true,
        val displayType: DisplayType
    ) : ErrorData()

    @Serializable
    data class AppUpdate(
        @SerialName("is_force_update")
        val isForceUpdate: Boolean? = null,
        @SerialName("message")
        val message: String? = null,
        @SerialName("latest_version_code")
        val latestVersionCode: Int? = null
    ) : ErrorData()

    data class Unauthorised(val error: String) : ErrorData()
    data class WrongTime(val error: String, val message: String) : ErrorData()

    object AdsIdNeeded : ErrorData()

    override fun toString(): String {
        return when (this) {
            is GeneralError -> getErrorFromGeneral(displayType)
            is AppUpdate -> "SDK update required"
            is Unauthorised -> error
            is WrongTime -> error
            is AdsIdNeeded -> "Ads Id is needed in the request."
        }
    }

    private fun getErrorFromGeneral(error: DisplayType): String {
        return when (error) {
            is DisplayType.Alert -> error.error
            is DisplayType.SnackBar -> error.error
            is DisplayType.Toast -> error.error
        }
    }

}
val somethingWentWrongSnack = ErrorData.GeneralError(true, DisplayType.SnackBar("Something went wrong."))
fun snackError(message: String) = ErrorData.GeneralError(true, DisplayType.SnackBar(message))



