package com.shipsy.ondemand.core.framework.util

import io.ktor.client.*
import io.ktor.client.call.*
import io.ktor.client.request.*

suspend inline fun <reified T> HttpClient.getRequest(
    url: String,
    headers: Map<String, Any>? = null,
    query: Map<String, Any>? = null
): T {
    return this.get(url) {
        headers?.forEach {
            header(it.key, it.value)
        }
        query?.forEach {
            parameter(it.key, it.value)
        }
    }.body()
}

suspend inline fun <reified requesT, reified outpuT> HttpClient.postRequest(
    url: String,
    body: requesT? = null,
    query: Map<String, Any>? = null,
    headers: Map<String, Any>? = null
): outpuT {
    return this.post(url) {
        query?.forEach {
            parameter(it.key, it.value)
        }
        headers?.forEach {
            header(it.key, it.value)
        }
        setBody(body)
    }.body()
}
