/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.orchestration.reg.newzk.client.zookeeper.strategy;

import io.shardingsphere.orchestration.reg.newzk.client.action.IProvider;
import io.shardingsphere.orchestration.reg.newzk.client.utility.PathUtil;
import io.shardingsphere.orchestration.reg.newzk.client.zookeeper.strategy.BaseStrategy;
import java.util.List;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Watcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UsualStrategy
extends BaseStrategy {
    private static final Logger log = LoggerFactory.getLogger(UsualStrategy.class);

    public UsualStrategy(IProvider provider) {
        super(provider);
    }

    @Override
    public byte[] getData(String key) throws KeeperException, InterruptedException {
        return this.getProvider().getData(this.getProvider().getRealPath(key));
    }

    @Override
    public void getData(String key, AsyncCallback.DataCallback callback, Object ctx) throws KeeperException, InterruptedException {
        this.getProvider().getData(this.getProvider().getRealPath(key), callback, ctx);
    }

    @Override
    public boolean checkExists(String key) throws KeeperException, InterruptedException {
        return this.getProvider().exists(this.getProvider().getRealPath(key));
    }

    @Override
    public boolean checkExists(String key, Watcher watcher) throws KeeperException, InterruptedException {
        return this.getProvider().exists(this.getProvider().getRealPath(key), watcher);
    }

    @Override
    public List<String> getChildren(String key) throws KeeperException, InterruptedException {
        return this.getProvider().getChildren(this.getProvider().getRealPath(key));
    }

    @Override
    public void createCurrentOnly(String key, String value, CreateMode createMode) throws KeeperException, InterruptedException {
        this.getProvider().create(this.getProvider().getRealPath(key), value, createMode);
    }

    @Override
    public void update(String key, String value) throws KeeperException, InterruptedException {
        this.getProvider().update(this.getProvider().getRealPath(key), value);
    }

    @Override
    public void deleteOnlyCurrent(String key) throws KeeperException, InterruptedException {
        this.getProvider().delete(this.getProvider().getRealPath(key));
    }

    @Override
    public void deleteOnlyCurrent(String key, AsyncCallback.VoidCallback callback, Object ctx) throws KeeperException, InterruptedException {
        this.getProvider().delete(this.getProvider().getRealPath(key), callback, ctx);
    }

    @Override
    public void createAllNeedPath(String key, String value, CreateMode createMode) throws KeeperException, InterruptedException {
        if (!key.contains("/")) {
            this.createCurrentOnly(key, value, createMode);
            return;
        }
        List<String> nodes = this.getProvider().getNecessaryPaths(key);
        for (int i = 0; i < nodes.size(); ++i) {
            try {
                if (i == nodes.size() - 1) {
                    this.createCurrentOnly(nodes.get(i), value, createMode);
                    continue;
                }
                this.createCurrentOnly(nodes.get(i), "", CreateMode.PERSISTENT);
                continue;
            }
            catch (KeeperException.NodeExistsException nodeExistsException) {
                // empty catch block
            }
        }
    }

    @Override
    public void deleteAllChildren(String key) throws KeeperException, InterruptedException {
        this.deleteChildren(this.getProvider().getRealPath(key), true);
    }

    private void deleteChildren(String path, boolean deleteCurrentNode) throws KeeperException, InterruptedException {
        List<String> children;
        try {
            children = this.getProvider().getChildren(path);
        }
        catch (KeeperException.NoNodeException ignored) {
            return;
        }
        for (String each : children) {
            this.deleteAllChildren(PathUtil.getRealPath(path, each));
        }
        if (deleteCurrentNode) {
            try {
                this.deleteOnlyCurrent(path);
            }
            catch (KeeperException.NotEmptyException ex) {
                log.warn("deleteCurrentNode exist children: {}, ex: {}", (Object)path, (Object)ex.getMessage());
                this.deleteChildren(path, true);
            }
            catch (KeeperException.NoNodeException ex) {
                log.warn("deleteCurrentNode node not exist: {}, ex: {}", (Object)path, (Object)ex.getMessage());
            }
        }
    }

    @Override
    public void deleteCurrentBranch(String key) throws KeeperException, InterruptedException {
        String path = this.getProvider().getRealPath(key);
        try {
            this.deleteOnlyCurrent(path);
        }
        catch (KeeperException.NotEmptyException ex) {
            this.deleteChildren(path, true);
        }
        catch (KeeperException.NoNodeException ex) {
            // empty catch block
        }
        String superPath = path.substring(0, path.lastIndexOf("/"));
        try {
            this.deleteRecursively(superPath);
        }
        catch (KeeperException.NotEmptyException ex) {
            log.warn("deleteCurrentBranch exist children: {}, ex: {}", (Object)path, (Object)ex.getMessage());
        }
        catch (KeeperException.NoNodeException noNodeException) {
            // empty catch block
        }
    }

    private void deleteRecursively(String path) throws KeeperException, InterruptedException {
        int index = path.lastIndexOf("/");
        if (index == 0) {
            this.deleteOnlyCurrent(path);
            return;
        }
        String superPath = path.substring(0, index);
        try {
            this.deleteOnlyCurrent(path);
            this.deleteRecursively(superPath);
        }
        catch (KeeperException.NotEmptyException ex) {
            log.info("deleteRecursively exist children: {}, ex: {}", (Object)path, (Object)ex.getMessage());
        }
    }
}

