/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.orchestration.reg.newzk.client.zookeeper.strategy;

import io.shardingsphere.orchestration.reg.newzk.client.action.ContentionCallback;
import io.shardingsphere.orchestration.reg.newzk.client.action.ITransactionProvider;
import io.shardingsphere.orchestration.reg.newzk.client.election.LeaderElection;
import io.shardingsphere.orchestration.reg.newzk.client.utility.PathUtil;
import io.shardingsphere.orchestration.reg.newzk.client.zookeeper.provider.BaseProvider;
import io.shardingsphere.orchestration.reg.newzk.client.zookeeper.strategy.ContentionStrategy;
import io.shardingsphere.orchestration.reg.newzk.client.zookeeper.transaction.ZooKeeperTransaction;
import java.util.List;
import java.util.Stack;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;

public final class TransactionContendStrategy
extends ContentionStrategy {
    public TransactionContendStrategy(ITransactionProvider provider) {
        super(provider);
    }

    @Override
    public void createAllNeedPath(String key, String value, CreateMode createMode) throws KeeperException, InterruptedException {
        LeaderElection election = this.buildCreateAllNeedElection(key, value, createMode, null);
        this.getProvider().executeContention(election);
        election.waitDone();
    }

    private LeaderElection buildCreateAllNeedElection(final String key, final String value, final CreateMode createMode, final ContentionCallback contentionCallback) {
        return new LeaderElection(){

            @Override
            public void action() throws KeeperException, InterruptedException {
                ZooKeeperTransaction transaction = new ZooKeeperTransaction(((BaseProvider)TransactionContendStrategy.this.getProvider()).getRootNode(), ((BaseProvider)TransactionContendStrategy.this.getProvider()).getHolder());
                TransactionContendStrategy.this.createBegin(key, value, createMode, transaction);
                transaction.commit();
            }

            @Override
            public void callback() {
                if (contentionCallback != null) {
                    contentionCallback.processResult();
                }
            }
        };
    }

    private void createBegin(String key, String value, CreateMode createMode, ZooKeeperTransaction transaction) throws KeeperException, InterruptedException {
        if (!key.contains("/")) {
            ((ITransactionProvider)this.getProvider()).createInTransaction(key, value, createMode, transaction);
            return;
        }
        List<String> nodes = this.getProvider().getNecessaryPaths(key);
        for (int i = 0; i < nodes.size(); ++i) {
            if (this.getProvider().exists(nodes.get(i))) continue;
            if (i == nodes.size() - 1) {
                ((ITransactionProvider)this.getProvider()).createInTransaction(nodes.get(i), value, createMode, transaction);
                continue;
            }
            ((ITransactionProvider)this.getProvider()).createInTransaction(nodes.get(i), "", createMode, transaction);
        }
    }

    @Override
    public void deleteAllChildren(final String key) throws KeeperException, InterruptedException {
        this.getProvider().executeContention(new LeaderElection(){

            @Override
            public void action() throws KeeperException, InterruptedException {
                ZooKeeperTransaction transaction = new ZooKeeperTransaction(((BaseProvider)TransactionContendStrategy.this.getProvider()).getRootNode(), ((BaseProvider)TransactionContendStrategy.this.getProvider()).getHolder());
                TransactionContendStrategy.this.deleteChildren(TransactionContendStrategy.this.getProvider().getRealPath(key), true, transaction);
                transaction.commit();
            }
        });
    }

    private void deleteChildren(String key, boolean deleteCurrentNode, ZooKeeperTransaction transaction) throws KeeperException, InterruptedException {
        List<String> children = this.getProvider().getChildren(key);
        for (String each : children) {
            String child = PathUtil.getRealPath(key, each);
            if (!this.getProvider().exists(child)) continue;
            this.deleteChildren(child, true, transaction);
        }
        if (deleteCurrentNode) {
            transaction.delete(key, -1);
        }
    }

    @Override
    public void deleteCurrentBranch(final String key) throws KeeperException, InterruptedException {
        this.getProvider().executeContention(new LeaderElection(){

            @Override
            public void action() throws KeeperException, InterruptedException {
                ZooKeeperTransaction transaction = new ZooKeeperTransaction(((BaseProvider)TransactionContendStrategy.this.getProvider()).getRootNode(), ((BaseProvider)TransactionContendStrategy.this.getProvider()).getHolder());
                TransactionContendStrategy.this.deleteBranch(TransactionContendStrategy.this.getProvider().getRealPath(key), transaction);
                transaction.commit();
            }
        });
    }

    private void deleteBranch(String key, ZooKeeperTransaction transaction) throws KeeperException, InterruptedException {
        this.deleteChildren(key, false, transaction);
        Stack<String> pathStack = this.getProvider().getDeletingPaths(key);
        String prePath = key;
        while (!pathStack.empty()) {
            boolean canDelete;
            String node = pathStack.pop();
            List<String> children = this.getProvider().getChildren(node);
            boolean bl = canDelete = children.isEmpty() || 1 == children.size();
            if (1 == children.size() && !PathUtil.getRealPath(node, children.get(0)).equals(prePath)) {
                canDelete = false;
            }
            if (this.getProvider().exists(node) && canDelete) {
                transaction.delete(node, -1);
            }
            prePath = node;
        }
    }
}

