/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.orchestration.reg.newzk.client.zookeeper.strategy;

import io.shardingsphere.orchestration.reg.newzk.client.action.IProvider;
import io.shardingsphere.orchestration.reg.newzk.client.retry.AsyncRetryCenter;
import io.shardingsphere.orchestration.reg.newzk.client.retry.DelayRetryPolicy;
import io.shardingsphere.orchestration.reg.newzk.client.zookeeper.operation.CreateAllNeedOperation;
import io.shardingsphere.orchestration.reg.newzk.client.zookeeper.operation.CreateCurrentOperation;
import io.shardingsphere.orchestration.reg.newzk.client.zookeeper.operation.DeleteAllChildrenOperation;
import io.shardingsphere.orchestration.reg.newzk.client.zookeeper.operation.DeleteCurrentBranchOperation;
import io.shardingsphere.orchestration.reg.newzk.client.zookeeper.operation.DeleteCurrentOperation;
import io.shardingsphere.orchestration.reg.newzk.client.zookeeper.operation.UpdateOperation;
import io.shardingsphere.orchestration.reg.newzk.client.zookeeper.section.Connection;
import io.shardingsphere.orchestration.reg.newzk.client.zookeeper.strategy.SyncRetryStrategy;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AsyncRetryStrategy
extends SyncRetryStrategy {
    private static final Logger log = LoggerFactory.getLogger(AsyncRetryStrategy.class);

    public AsyncRetryStrategy(IProvider provider, DelayRetryPolicy delayRetryPolicy) {
        super(provider, delayRetryPolicy);
        AsyncRetryCenter.INSTANCE.init(this.getDelayRetryPolicy());
        AsyncRetryCenter.INSTANCE.start();
    }

    @Override
    public void createCurrentOnly(String key, String value, CreateMode createMode) throws KeeperException, InterruptedException {
        String path = this.getProvider().getRealPath(key);
        try {
            this.getProvider().create(path, value, createMode);
        }
        catch (KeeperException ex) {
            if (Connection.needRetry(ex)) {
                log.warn(String.format("AsyncRetryStrategy SessionExpiredException createCurrentOnly: %s", path), (Throwable)ex);
                AsyncRetryCenter.INSTANCE.add(new CreateCurrentOperation(this.getProvider(), path, value, createMode));
            }
            throw ex;
        }
    }

    @Override
    public void update(String key, String value) throws KeeperException, InterruptedException {
        String path = this.getProvider().getRealPath(key);
        try {
            this.getProvider().update(path, value);
        }
        catch (KeeperException ex) {
            if (Connection.needRetry(ex)) {
                log.warn(String.format("AsyncRetryStrategy SessionExpiredException update: %s", path), (Throwable)ex);
                AsyncRetryCenter.INSTANCE.add(new UpdateOperation(this.getProvider(), path, value));
            }
            throw ex;
        }
    }

    @Override
    public void deleteOnlyCurrent(String key) throws KeeperException, InterruptedException {
        String path = this.getProvider().getRealPath(key);
        try {
            this.getProvider().delete(path);
        }
        catch (KeeperException ex) {
            if (Connection.needRetry(ex)) {
                log.warn(String.format("AsyncRetryStrategy SessionExpiredException deleteOnlyCurrent: %s", path), (Throwable)ex);
                AsyncRetryCenter.INSTANCE.add(new DeleteCurrentOperation(this.getProvider(), path));
            }
            throw ex;
        }
    }

    @Override
    public void createAllNeedPath(String key, String value, CreateMode createMode) throws KeeperException, InterruptedException {
        try {
            super.createAllNeedPath(key, value, createMode);
        }
        catch (KeeperException ex) {
            if (Connection.needRetry(ex)) {
                log.warn(String.format("AllAsyncRetryStrategy SessionExpiredException CreateAllNeedOperation: %s", key), (Throwable)ex);
                AsyncRetryCenter.INSTANCE.add(new CreateAllNeedOperation(this.getProvider(), key, value, createMode));
            }
            throw ex;
        }
    }

    @Override
    public void deleteAllChildren(String key) throws KeeperException, InterruptedException {
        try {
            super.deleteAllChildren(key);
        }
        catch (KeeperException ex) {
            if (Connection.needRetry(ex)) {
                log.warn(String.format("AllAsyncRetryStrategy SessionExpiredException deleteAllChildren: %s", key), (Throwable)ex);
                AsyncRetryCenter.INSTANCE.add(new DeleteAllChildrenOperation(this.getProvider(), key));
            }
            throw ex;
        }
    }

    @Override
    public void deleteCurrentBranch(String key) throws KeeperException, InterruptedException {
        try {
            super.deleteCurrentBranch(key);
        }
        catch (KeeperException ex) {
            if (Connection.needRetry(ex)) {
                log.warn(String.format("AllAsyncRetryStrategy SessionExpiredException deleteCurrentBranch: %s", key), (Throwable)ex);
                AsyncRetryCenter.INSTANCE.add(new DeleteCurrentBranchOperation(this.getProvider(), key));
            }
            throw ex;
        }
    }
}

