/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.orchestration.reg.newzk.client.zookeeper.section;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.zookeeper.KeeperException;

public final class Connection {
    private static final Map<Integer, Boolean> EXCEPTION_RESETS = new ConcurrentHashMap<Integer, Boolean>();

    public static boolean needRetry(KeeperException keeperException) {
        return EXCEPTION_RESETS.containsKey(keeperException.code().intValue());
    }

    public static boolean needReset(KeeperException keeperException) throws KeeperException {
        int code = keeperException.code().intValue();
        if (!EXCEPTION_RESETS.containsKey(code)) {
            throw keeperException;
        }
        return EXCEPTION_RESETS.get(code);
    }

    private Connection() {
    }

    static {
        EXCEPTION_RESETS.put(KeeperException.Code.SESSIONEXPIRED.intValue(), true);
        EXCEPTION_RESETS.put(KeeperException.Code.SESSIONMOVED.intValue(), true);
        EXCEPTION_RESETS.put(KeeperException.Code.CONNECTIONLOSS.intValue(), false);
        EXCEPTION_RESETS.put(KeeperException.Code.OPERATIONTIMEOUT.intValue(), false);
    }
}

