/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.orchestration.reg.newzk.client.zookeeper.section;

import io.shardingsphere.orchestration.reg.newzk.client.retry.DelayRetryPolicy;
import io.shardingsphere.orchestration.reg.newzk.client.zookeeper.base.BaseClientFactory;
import io.shardingsphere.orchestration.reg.newzk.client.zookeeper.base.BaseContext;

public final class ClientContext
extends BaseContext {
    private DelayRetryPolicy delayRetryPolicy;
    private BaseClientFactory clientFactory;

    public ClientContext(String servers, int sessionTimeoutMilliseconds) {
        this.setServers(servers);
        this.setSessionTimeOut(sessionTimeoutMilliseconds);
    }

    public void updateContext(ClientContext context) {
        this.delayRetryPolicy = context.getDelayRetryPolicy();
        this.clientFactory = context.clientFactory;
        this.getWatchers().clear();
        this.getWatchers().putAll(context.getWatchers());
    }

    @Override
    public void close() {
        super.close();
        this.delayRetryPolicy = null;
        this.clientFactory = null;
    }

    public void setDelayRetryPolicy(DelayRetryPolicy delayRetryPolicy) {
        this.delayRetryPolicy = delayRetryPolicy;
    }

    public void setClientFactory(BaseClientFactory clientFactory) {
        this.clientFactory = clientFactory;
    }

    public DelayRetryPolicy getDelayRetryPolicy() {
        return this.delayRetryPolicy;
    }

    public BaseClientFactory getClientFactory() {
        return this.clientFactory;
    }
}

