/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.orchestration.reg.newzk.client.zookeeper.base;

import com.google.common.base.Strings;
import io.shardingsphere.orchestration.reg.newzk.client.zookeeper.base.BaseContext;
import io.shardingsphere.orchestration.reg.newzk.client.zookeeper.section.ZookeeperEventListener;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Holder {
    private static final Logger log = LoggerFactory.getLogger(Holder.class);
    private final CountDownLatch connectLatch = new CountDownLatch(1);
    private final BaseContext context;
    private ZooKeeper zooKeeper;
    private boolean connected;

    public void start() throws IOException, InterruptedException {
        this.initZookeeper();
        this.connectLatch.await();
    }

    protected void start(int wait, TimeUnit units) throws IOException, InterruptedException {
        this.initZookeeper();
        this.connectLatch.await(wait, units);
    }

    protected void initZookeeper() throws IOException {
        this.zooKeeper = new ZooKeeper(this.context.getServers(), this.context.getSessionTimeOut(), this.startWatcher());
        if (!Strings.isNullOrEmpty((String)this.context.getScheme())) {
            this.zooKeeper.addAuthInfo(this.context.getScheme(), this.context.getAuth());
        }
    }

    private Watcher startWatcher() {
        return new Watcher(){

            public void process(WatchedEvent event) {
                Holder.this.processConnection(event);
                if (!Holder.this.isConnected()) {
                    return;
                }
                Holder.this.processGlobalListener(event);
                if (event.getType() == Watcher.Event.EventType.None) {
                    return;
                }
                if (Watcher.Event.EventType.NodeDeleted == event.getType() || Holder.this.checkPath(event.getPath())) {
                    Holder.this.processUsualListener(event);
                }
            }
        };
    }

    protected void processConnection(WatchedEvent event) {
        if (Watcher.Event.EventType.None == event.getType()) {
            if (Watcher.Event.KeeperState.SyncConnected == event.getState()) {
                this.connectLatch.countDown();
                this.connected = true;
            } else if (Watcher.Event.KeeperState.Expired == event.getState()) {
                this.connected = false;
                try {
                    this.reset();
                }
                catch (IOException | InterruptedException ex) {
                    log.error("event state Expired: {}", (Object)ex.getMessage(), (Object)ex);
                }
            } else if (Watcher.Event.KeeperState.Disconnected == event.getState()) {
                this.connected = false;
            }
        }
    }

    private void processGlobalListener(WatchedEvent event) {
        if (null != this.context.getGlobalZookeeperEventListener()) {
            this.context.getGlobalZookeeperEventListener().process(event);
        }
    }

    private void processUsualListener(WatchedEvent event) {
        if (!this.context.getWatchers().isEmpty()) {
            for (ZookeeperEventListener zookeeperEventListener : this.context.getWatchers().values()) {
                if (null != zookeeperEventListener.getPath() && !event.getPath().startsWith(zookeeperEventListener.getPath())) continue;
                zookeeperEventListener.process(event);
            }
        }
    }

    private boolean checkPath(String path) {
        try {
            return null != this.zooKeeper.exists(path, true);
        }
        catch (InterruptedException | KeeperException ignore) {
            return false;
        }
    }

    public void reset() throws IOException, InterruptedException {
        this.close();
        this.start();
    }

    public void close() {
        try {
            this.zooKeeper.register(new Watcher(){

                public void process(WatchedEvent watchedEvent) {
                }
            });
            this.zooKeeper.close();
            this.connected = false;
            this.context.close();
        }
        catch (InterruptedException ex) {
            log.warn("Holder close:{}", (Object)ex.getMessage());
        }
    }

    @ConstructorProperties(value={"context"})
    public Holder(BaseContext context) {
        this.context = context;
    }

    public CountDownLatch getConnectLatch() {
        return this.connectLatch;
    }

    public ZooKeeper getZooKeeper() {
        return this.zooKeeper;
    }

    public boolean isConnected() {
        return this.connected;
    }

    protected BaseContext getContext() {
        return this.context;
    }

    protected void setConnected(boolean connected) {
        this.connected = connected;
    }
}

