/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.orchestration.reg.newzk.client.zookeeper.base;

import io.shardingsphere.orchestration.reg.newzk.client.action.IProvider;
import io.shardingsphere.orchestration.reg.newzk.client.retry.DelayPolicyExecutor;
import io.shardingsphere.orchestration.reg.newzk.client.zookeeper.section.Connection;
import java.beans.ConstructorProperties;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import org.apache.zookeeper.KeeperException;

public abstract class BaseOperation
implements Delayed {
    private final IProvider provider;
    private DelayPolicyExecutor delayPolicyExecutor;

    @Override
    public final long getDelay(TimeUnit timeUnit) {
        long absoluteBlock = this.delayPolicyExecutor.getNextTick() - System.currentTimeMillis();
        return timeUnit.convert(absoluteBlock, TimeUnit.MILLISECONDS);
    }

    @Override
    public final int compareTo(Delayed delayed) {
        return (int)(this.getDelay(TimeUnit.MILLISECONDS) - delayed.getDelay(TimeUnit.MILLISECONDS));
    }

    protected abstract void execute() throws KeeperException, InterruptedException;

    public boolean executeOperation() throws KeeperException, InterruptedException {
        boolean result;
        try {
            this.execute();
            result = true;
        }
        catch (KeeperException ex) {
            if (Connection.needReset(ex)) {
                this.provider.resetConnection();
            }
            result = false;
        }
        if (!result && this.delayPolicyExecutor.hasNext()) {
            this.delayPolicyExecutor.next();
            return true;
        }
        return false;
    }

    @ConstructorProperties(value={"provider"})
    public BaseOperation(IProvider provider) {
        this.provider = provider;
    }

    public IProvider getProvider() {
        return this.provider;
    }

    public void setDelayPolicyExecutor(DelayPolicyExecutor delayPolicyExecutor) {
        this.delayPolicyExecutor = delayPolicyExecutor;
    }
}

