/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.orchestration.reg.newzk.client.zookeeper.base;

import io.shardingsphere.orchestration.reg.newzk.client.action.IClient;
import io.shardingsphere.orchestration.reg.newzk.client.zookeeper.base.BaseClient;
import io.shardingsphere.orchestration.reg.newzk.client.zookeeper.base.BaseContext;
import io.shardingsphere.orchestration.reg.newzk.client.zookeeper.section.ZookeeperEventListener;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.data.ACL;

public abstract class BaseClientFactory {
    private BaseClient client;
    private ZookeeperEventListener globalZookeeperEventListener;
    private String namespace;
    private String scheme;
    private byte[] auth;
    private List<ACL> authorities;
    private BaseContext context;

    public IClient start() throws IOException, InterruptedException {
        this.prepareClient();
        this.client.start();
        return this.client;
    }

    public IClient start(int waitingTime, TimeUnit timeUnit) throws IOException, InterruptedException, KeeperException {
        this.prepareClient();
        if (!this.client.start(waitingTime, timeUnit)) {
            this.client.close();
            throw new KeeperException.OperationTimeoutException();
        }
        return this.client;
    }

    private void prepareClient() {
        this.client.setRootNode(this.namespace);
        if (null == this.scheme) {
            this.authorities = ZooDefs.Ids.OPEN_ACL_UNSAFE;
        }
        this.client.setAuthorities(this.scheme, this.auth, this.authorities);
        if (null != this.globalZookeeperEventListener) {
            this.client.registerWatch(this.globalZookeeperEventListener);
        }
    }

    protected void setClient(BaseClient client) {
        this.client = client;
    }

    protected void setGlobalZookeeperEventListener(ZookeeperEventListener globalZookeeperEventListener) {
        this.globalZookeeperEventListener = globalZookeeperEventListener;
    }

    protected void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    protected void setScheme(String scheme) {
        this.scheme = scheme;
    }

    protected void setAuth(byte[] auth) {
        this.auth = auth;
    }

    protected void setAuthorities(List<ACL> authorities) {
        this.authorities = authorities;
    }

    protected void setContext(BaseContext context) {
        this.context = context;
    }

    protected BaseClient getClient() {
        return this.client;
    }

    protected ZookeeperEventListener getGlobalZookeeperEventListener() {
        return this.globalZookeeperEventListener;
    }

    protected String getNamespace() {
        return this.namespace;
    }

    protected String getScheme() {
        return this.scheme;
    }

    protected byte[] getAuth() {
        return this.auth;
    }

    protected List<ACL> getAuthorities() {
        return this.authorities;
    }

    protected BaseContext getContext() {
        return this.context;
    }
}

