/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.orchestration.reg.newzk.client.zookeeper;

import io.shardingsphere.orchestration.reg.newzk.client.action.IExecStrategy;
import io.shardingsphere.orchestration.reg.newzk.client.zookeeper.base.BaseClient;
import io.shardingsphere.orchestration.reg.newzk.client.zookeeper.base.BaseContext;
import io.shardingsphere.orchestration.reg.newzk.client.zookeeper.provider.TransactionProvider;
import io.shardingsphere.orchestration.reg.newzk.client.zookeeper.section.ClientContext;
import io.shardingsphere.orchestration.reg.newzk.client.zookeeper.section.StrategyType;
import io.shardingsphere.orchestration.reg.newzk.client.zookeeper.strategy.AsyncRetryStrategy;
import io.shardingsphere.orchestration.reg.newzk.client.zookeeper.strategy.ContentionStrategy;
import io.shardingsphere.orchestration.reg.newzk.client.zookeeper.strategy.SyncRetryStrategy;
import io.shardingsphere.orchestration.reg.newzk.client.zookeeper.strategy.TransactionContendStrategy;
import io.shardingsphere.orchestration.reg.newzk.client.zookeeper.strategy.UsualStrategy;
import io.shardingsphere.orchestration.reg.newzk.client.zookeeper.transaction.BaseTransaction;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Watcher;

public class UsualClient
extends BaseClient {
    private final Map<StrategyType, IExecStrategy> strategies = new ConcurrentHashMap<StrategyType, IExecStrategy>();
    private IExecStrategy execStrategy;

    protected UsualClient(BaseContext context) {
        super(context);
    }

    @Override
    public void close() {
        this.strategies.clear();
        super.close();
    }

    @Override
    public synchronized void useExecStrategy(StrategyType strategyType) {
        if (this.strategies.containsKey((Object)strategyType)) {
            this.execStrategy = this.strategies.get((Object)strategyType);
            return;
        }
        TransactionProvider provider = new TransactionProvider(this.getRootNode(), this.getHolder(), true, this.getAuthorities());
        switch (strategyType) {
            case USUAL: {
                this.execStrategy = new UsualStrategy(provider);
                break;
            }
            case CONTEND: {
                this.execStrategy = new ContentionStrategy(provider);
                break;
            }
            case TRANSACTION_CONTEND: {
                this.execStrategy = new TransactionContendStrategy(provider);
                break;
            }
            case SYNC_RETRY: {
                this.execStrategy = new SyncRetryStrategy(provider, ((ClientContext)this.getContext()).getDelayRetryPolicy());
                break;
            }
            case ASYNC_RETRY: {
                this.execStrategy = new AsyncRetryStrategy(provider, ((ClientContext)this.getContext()).getDelayRetryPolicy());
                break;
            }
            default: {
                this.execStrategy = new UsualStrategy(provider);
            }
        }
        this.strategies.put(strategyType, this.execStrategy);
    }

    @Override
    public String getDataString(String key) throws KeeperException, InterruptedException {
        return this.execStrategy.getDataString(key);
    }

    @Override
    public byte[] getData(String key) throws KeeperException, InterruptedException {
        return this.execStrategy.getData(key);
    }

    @Override
    public void getData(String key, AsyncCallback.DataCallback callback, Object ctx) throws KeeperException, InterruptedException {
        this.execStrategy.getData(key, callback, ctx);
    }

    @Override
    public boolean checkExists(String key) throws KeeperException, InterruptedException {
        return this.execStrategy.checkExists(key);
    }

    @Override
    public boolean checkExists(String key, Watcher watcher) throws KeeperException, InterruptedException {
        return this.execStrategy.checkExists(key, watcher);
    }

    @Override
    public List<String> getChildren(String key) throws KeeperException, InterruptedException {
        return this.execStrategy.getChildren(key);
    }

    @Override
    public void createCurrentOnly(String key, String value, CreateMode createMode) throws KeeperException, InterruptedException {
        this.createNamespace();
        if (this.getRootNode().equals(key)) {
            return;
        }
        this.execStrategy.createCurrentOnly(key, value, createMode);
    }

    @Override
    public void createAllNeedPath(String key, String value, CreateMode createMode) throws KeeperException, InterruptedException {
        this.createNamespace();
        if (this.getRootNode().equals(key)) {
            return;
        }
        this.execStrategy.createAllNeedPath(key, value, createMode);
    }

    @Override
    public void update(String key, String value) throws KeeperException, InterruptedException {
        this.execStrategy.update(key, value);
    }

    @Override
    public void deleteOnlyCurrent(String key) throws KeeperException, InterruptedException {
        if (this.getRootNode().equals(key)) {
            this.deleteNamespace();
            return;
        }
        this.execStrategy.deleteOnlyCurrent(key);
    }

    @Override
    public void deleteOnlyCurrent(String key, AsyncCallback.VoidCallback callback, Object ctx) throws KeeperException, InterruptedException {
        if (this.getRootNode().equals(key)) {
            this.deleteNamespace();
            return;
        }
        this.execStrategy.deleteOnlyCurrent(key, callback, ctx);
    }

    @Override
    public void deleteAllChildren(String key) throws KeeperException, InterruptedException {
        this.execStrategy.deleteAllChildren(key);
        if (this.getRootNode().equals(key)) {
            this.setRootExist(false);
        }
    }

    @Override
    public void deleteCurrentBranch(String key) throws KeeperException, InterruptedException {
        this.execStrategy.deleteCurrentBranch(key);
        if (!this.execStrategy.checkExists(this.getRootNode())) {
            this.setRootExist(false);
        }
    }

    @Override
    public BaseTransaction transaction() {
        return this.execStrategy.transaction();
    }

    @Override
    public IExecStrategy getExecStrategy() {
        return this.execStrategy;
    }
}

