/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.orchestration.reg.newzk.client.zookeeper;

import io.shardingsphere.orchestration.reg.newzk.client.action.IClient;
import io.shardingsphere.orchestration.reg.newzk.client.retry.DelayRetryPolicy;
import io.shardingsphere.orchestration.reg.newzk.client.utility.PathUtil;
import io.shardingsphere.orchestration.reg.newzk.client.zookeeper.CacheClient;
import io.shardingsphere.orchestration.reg.newzk.client.zookeeper.UsualClient;
import io.shardingsphere.orchestration.reg.newzk.client.zookeeper.base.BaseClient;
import io.shardingsphere.orchestration.reg.newzk.client.zookeeper.base.BaseClientFactory;
import io.shardingsphere.orchestration.reg.newzk.client.zookeeper.section.ClientContext;
import io.shardingsphere.orchestration.reg.newzk.client.zookeeper.section.ZookeeperEventListener;
import java.io.IOException;
import java.util.List;
import org.apache.zookeeper.data.ACL;

public final class ClientFactory
extends BaseClientFactory {
    private DelayRetryPolicy delayRetryPolicy;

    public ClientFactory newClient(String servers, int sessionTimeoutMilliseconds) {
        int wait = sessionTimeoutMilliseconds;
        if (sessionTimeoutMilliseconds == 0) {
            wait = 60000;
        }
        this.setContext(new ClientContext(servers, wait));
        this.setClient(new UsualClient(this.getContext()));
        return this;
    }

    synchronized BaseClientFactory newClientByOriginal(boolean closeOriginal) {
        BaseClient oldClient = this.getClient();
        this.setClient(new UsualClient(this.getContext()));
        if (closeOriginal) {
            oldClient.close();
        }
        return this;
    }

    ClientFactory newCacheClient(String servers, int sessionTimeoutMilliseconds) {
        this.setContext(new ClientContext(servers, sessionTimeoutMilliseconds));
        this.setClient(new CacheClient(this.getContext()));
        return this;
    }

    public ClientFactory watch(ZookeeperEventListener globalZookeeperEventListener) {
        this.setGlobalZookeeperEventListener(globalZookeeperEventListener);
        return this;
    }

    public ClientFactory setClientNamespace(String namespace) {
        this.setNamespace(PathUtil.checkPath(namespace));
        return this;
    }

    public ClientFactory authorization(String scheme, byte[] auth, List<ACL> authorities) {
        this.setScheme(scheme);
        this.setAuth(auth);
        this.setAuthorities(authorities);
        return this;
    }

    public ClientFactory setRetryPolicy(DelayRetryPolicy delayRetryPolicy) {
        this.delayRetryPolicy = delayRetryPolicy;
        return this;
    }

    @Override
    public IClient start() throws IOException, InterruptedException {
        ((ClientContext)this.getContext()).setDelayRetryPolicy(this.delayRetryPolicy);
        ((ClientContext)this.getContext()).setClientFactory(this);
        return super.start();
    }
}

