/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.orchestration.reg.newzk.client.zookeeper;

import io.shardingsphere.orchestration.reg.newzk.client.cache.CacheStrategy;
import io.shardingsphere.orchestration.reg.newzk.client.cache.PathTree;
import io.shardingsphere.orchestration.reg.newzk.client.utility.PathUtil;
import io.shardingsphere.orchestration.reg.newzk.client.zookeeper.UsualClient;
import io.shardingsphere.orchestration.reg.newzk.client.zookeeper.base.BaseContext;
import java.io.IOException;
import java.util.List;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;

public final class CacheClient
extends UsualClient {
    private PathTree pathTree;

    CacheClient(BaseContext context) {
        super(context);
    }

    @Override
    public void start() throws IOException, InterruptedException {
        super.start();
        try {
            this.useCacheStrategy(CacheStrategy.WATCH);
        }
        catch (KeeperException keeperException) {
            // empty catch block
        }
    }

    @Override
    public void close() {
        super.close();
        this.pathTree.close();
    }

    private void useCacheStrategy(CacheStrategy cacheStrategy) throws KeeperException, InterruptedException {
        switch (cacheStrategy) {
            case WATCH: {
                this.pathTree = new PathTree(this.getRootNode(), this);
                this.pathTree.watch();
                break;
            }
            case ALL: {
                this.pathTree = this.loadPathTree();
                this.pathTree.refreshPeriodic(3000L);
                break;
            }
        }
    }

    private PathTree loadPathTree() throws KeeperException, InterruptedException {
        return this.loadPathTree(this.getRootNode());
    }

    private PathTree loadPathTree(String treeRoot) throws KeeperException, InterruptedException {
        PathTree result = new PathTree(treeRoot, this);
        result.load();
        result.watch();
        return result;
    }

    @Override
    public void createCurrentOnly(String key, String value, CreateMode createMode) throws KeeperException, InterruptedException {
        super.createCurrentOnly(key, value, createMode);
        this.pathTree.put(PathUtil.getRealPath(this.getRootNode(), key), value);
    }

    @Override
    public void deleteOnlyCurrent(String key) throws KeeperException, InterruptedException {
        super.deleteOnlyCurrent(key);
        this.pathTree.delete(PathUtil.getRealPath(this.getRootNode(), key));
    }

    @Override
    public void deleteOnlyCurrent(String key, AsyncCallback.VoidCallback callback, Object ctx) throws KeeperException, InterruptedException {
        super.deleteOnlyCurrent(key, callback, ctx);
        this.pathTree.delete(PathUtil.getRealPath(this.getRootNode(), key));
    }

    @Override
    public byte[] getData(String key) throws KeeperException, InterruptedException {
        String path = PathUtil.getRealPath(this.getRootNode(), key);
        byte[] data = this.pathTree.getValue(path);
        if (null != data) {
            return data;
        }
        return this.getExecStrategy().getData(key);
    }

    @Override
    public List<String> getChildren(String key) throws KeeperException, InterruptedException {
        String path = PathUtil.getRealPath(this.getRootNode(), key);
        List<String> keys = this.pathTree.getChildren(path);
        if (keys != null && !keys.isEmpty()) {
            return keys;
        }
        return this.getExecStrategy().getChildren(PathUtil.getRealPath(this.getRootNode(), key));
    }
}

