/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.orchestration.reg.newzk.client.utility;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;

public final class PathUtil {
    public static String getRealPath(String root, String path) {
        return PathUtil.adjustPath(root, path);
    }

    private static String adjustPath(String root, String path) {
        if (Strings.isNullOrEmpty((String)path)) {
            throw new IllegalArgumentException("path should have content!");
        }
        String rootPath = root;
        if (!root.startsWith("/")) {
            rootPath = "/" + root;
        }
        String realPath = path;
        if (!path.startsWith("/")) {
            realPath = "/" + path;
        }
        if (!realPath.startsWith(rootPath)) {
            return rootPath + realPath;
        }
        return realPath;
    }

    public static Stack<String> getPathReverseNodes(String root, String path) {
        String realPath = PathUtil.adjustPath(root, path);
        Stack<String> pathStack = new Stack<String>();
        int index = 1;
        int position = realPath.indexOf("/", index);
        do {
            pathStack.push(realPath.substring(0, position));
        } while ((position = realPath.indexOf("/", index = position + 1)) > -1);
        pathStack.push(realPath);
        return pathStack;
    }

    public static List<String> getPathOrderNodes(String root, String path) {
        String realPath = PathUtil.adjustPath(root, path);
        ArrayList<String> paths = new ArrayList<String>();
        int index = 1;
        int position = realPath.indexOf("/", index);
        do {
            paths.add(realPath.substring(0, position));
        } while ((position = realPath.indexOf("/", index = position + 1)) > -1);
        paths.add(realPath);
        return paths;
    }

    public static List<String> getShortPathNodes(String path) {
        String realPath = PathUtil.checkPath(path);
        ArrayList<String> paths = new ArrayList<String>();
        char[] chars = realPath.toCharArray();
        StringBuilder builder = new StringBuilder("/");
        for (int i = 1; i < chars.length; ++i) {
            if (chars[i] == "/".charAt(0)) {
                paths.add(builder.toString());
                builder = new StringBuilder("/");
                continue;
            }
            builder.append(chars[i]);
            if (i != chars.length - 1) continue;
            paths.add(builder.toString());
        }
        return paths;
    }

    public static String checkPath(String key) {
        Preconditions.checkNotNull((Object)key, (Object)"path should not be null");
        String path = key;
        if (path.charAt(0) != '/' || path.charAt(path.length() - 1) == '/') {
            path = "/" + path;
        }
        if (path.charAt(path.length() - 1) == '/') {
            path = "/" + path;
        }
        char previous = '/';
        char[] chars = path.toCharArray();
        StringBuilder builder = new StringBuilder();
        builder.append(previous);
        for (int i = 1; i < chars.length; ++i) {
            char c = chars[i];
            if (c == '\u0000' || c == '/' && previous == '/') continue;
            if (c == '.') {
                boolean preWarn;
                boolean bl = preWarn = previous == '/' || previous == '.' && chars[i - 2] == '/';
                if (previous == '/' && (i + 1 == chars.length || chars[i + 1] == '/')) {
                    ++i;
                    continue;
                }
                if (previous == '.' && chars[i - 2] == '/' && (i + 1 == chars.length || chars[i + 1] == '/')) {
                    i += 2;
                    continue;
                }
            }
            if (c > '\u0000' && c < '\u001f' || c > '\u007f' && c < '\u009f' || c > '\ud800' && c < '\uf8ff' || c > '\ufff0' && c < '\uffff') continue;
            builder.append(c);
            previous = c;
        }
        return builder.toString();
    }

    private PathUtil() {
    }
}

