/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.orchestration.reg.newzk.client.retry;

import io.shardingsphere.orchestration.reg.newzk.client.zookeeper.base.BaseOperation;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RetryThread
extends Thread {
    private static final Logger log = LoggerFactory.getLogger(RetryThread.class);
    private final int corePoolSize;
    private final int maximumPoolSize;
    private final long keepAliveTime = 0L;
    private final int closeDelay = 60;
    private final DelayQueue<BaseOperation> queue;
    private final ThreadPoolExecutor retryExecutor;

    public RetryThread(DelayQueue<BaseOperation> queue) {
        this.maximumPoolSize = this.corePoolSize = Runtime.getRuntime().availableProcessors();
        this.keepAliveTime = 0L;
        this.closeDelay = 60;
        this.queue = queue;
        this.retryExecutor = new ThreadPoolExecutor(this.corePoolSize, this.maximumPoolSize, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(10), new ThreadFactory(){
            private final AtomicInteger threadIndex = new AtomicInteger(0);

            @Override
            public Thread newThread(Runnable runnable) {
                Thread thread = new Thread(runnable);
                thread.setDaemon(true);
                thread.setName("zk-retry-" + this.threadIndex.incrementAndGet());
                return thread;
            }
        });
        this.addDelayedShutdownHook(this.retryExecutor, 60L, TimeUnit.SECONDS);
    }

    @Override
    public void run() {
        while (true) {
            BaseOperation operation;
            try {
                operation = (BaseOperation)this.queue.take();
            }
            catch (InterruptedException ex) {
                log.error("retry interrupt ex: {}", (Object)ex.getMessage());
                continue;
            }
            this.retryExecutor.submit(new Runnable(){

                @Override
                public void run() {
                    boolean result;
                    try {
                        result = operation.executeOperation();
                    }
                    catch (InterruptedException | KeeperException ex) {
                        result = false;
                        log.error("retry disrupt operation: {}, ex: {}", (Object)operation.toString(), (Object)ex.getMessage());
                    }
                    if (result) {
                        RetryThread.this.queue.offer(operation);
                    }
                }
            });
        }
    }

    private void addDelayedShutdownHook(final ExecutorService service, final long terminationTimeout, final TimeUnit timeUnit) {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    RetryThread.this.queue.clear();
                    service.shutdown();
                    service.awaitTermination(terminationTimeout, timeUnit);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        });
        thread.setName("retry shutdown hook");
        Runtime.getRuntime().addShutdownHook(thread);
    }
}

