/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.orchestration.reg.newzk.client.retry;

import io.shardingsphere.orchestration.reg.newzk.client.action.IProvider;
import io.shardingsphere.orchestration.reg.newzk.client.retry.DelayPolicyExecutor;
import io.shardingsphere.orchestration.reg.newzk.client.retry.DelayRetryPolicy;
import io.shardingsphere.orchestration.reg.newzk.client.zookeeper.section.Connection;
import org.apache.zookeeper.KeeperException;

public abstract class RetryCallable {
    private final IProvider provider;
    private final DelayPolicyExecutor delayPolicyExecutor;

    public RetryCallable(IProvider provider, DelayRetryPolicy delayRetryPolicy) {
        this.provider = provider;
        this.delayPolicyExecutor = new DelayPolicyExecutor(delayRetryPolicy);
    }

    public abstract void call() throws KeeperException, InterruptedException;

    public void exec() throws KeeperException, InterruptedException {
        try {
            this.call();
        }
        catch (KeeperException ex) {
            this.delayPolicyExecutor.next();
            if (Connection.needReset(ex)) {
                this.provider.resetConnection();
            }
            this.execDelay();
        }
    }

    private void execDelay() throws KeeperException, InterruptedException {
        block1: {
            long delay;
            while ((delay = this.delayPolicyExecutor.getNextTick() - System.currentTimeMillis()) > 0L) {
                Thread.sleep(delay);
            }
            if (!this.delayPolicyExecutor.hasNext()) break block1;
            this.exec();
        }
    }

    protected IProvider getProvider() {
        return this.provider;
    }

    protected DelayPolicyExecutor getDelayPolicyExecutor() {
        return this.delayPolicyExecutor;
    }
}

