/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.orchestration.reg.newzk.client.retry;

import io.shardingsphere.orchestration.reg.newzk.client.retry.DelayPolicyExecutor;
import io.shardingsphere.orchestration.reg.newzk.client.retry.DelayRetryPolicy;
import io.shardingsphere.orchestration.reg.newzk.client.retry.RetryThread;
import io.shardingsphere.orchestration.reg.newzk.client.zookeeper.base.BaseOperation;
import java.util.concurrent.DelayQueue;

public enum AsyncRetryCenter {
    INSTANCE;

    private final DelayQueue<BaseOperation> queue = new DelayQueue();
    private final RetryThread retryThread = new RetryThread(this.queue);
    private boolean started;
    private DelayRetryPolicy delayRetryPolicy;

    public void init(DelayRetryPolicy delayRetryPolicy) {
        this.delayRetryPolicy = null == delayRetryPolicy ? DelayRetryPolicy.defaultDelayPolicy() : delayRetryPolicy;
    }

    public synchronized void start() {
        if (this.started) {
            return;
        }
        this.retryThread.setName("retry-thread");
        this.retryThread.start();
        this.started = true;
    }

    public void add(BaseOperation operation) {
        if (null == this.delayRetryPolicy) {
            this.delayRetryPolicy = DelayRetryPolicy.defaultDelayPolicy();
        }
        operation.setDelayPolicyExecutor(new DelayPolicyExecutor(this.delayRetryPolicy));
        this.queue.offer(operation);
    }
}

