/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.orchestration.reg.newzk.client.election;

import io.shardingsphere.orchestration.reg.newzk.client.action.IProvider;
import io.shardingsphere.orchestration.reg.newzk.client.utility.PathUtil;
import io.shardingsphere.orchestration.reg.newzk.client.zookeeper.section.WatcherCreator;
import io.shardingsphere.orchestration.reg.newzk.client.zookeeper.section.ZookeeperEventListener;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LeaderElection {
    private static final Logger log = LoggerFactory.getLogger(LeaderElection.class);
    private int retryCount = 3;
    private boolean done;

    public void executeContention(String nodeBeContend, final IProvider provider) throws KeeperException, InterruptedException {
        final String realNode = provider.getRealPath(nodeBeContend);
        String contendNode = PathUtil.getRealPath(realNode, "CHANGING_KEY");
        boolean canBegin = this.contend(contendNode, provider, new ZookeeperEventListener(contendNode){

            @Override
            public void process(WatchedEvent event) {
                try {
                    LeaderElection.this.retryCount--;
                    if (LeaderElection.this.retryCount < 0) {
                        return;
                    }
                    LeaderElection.this.executeContention(realNode, provider);
                }
                catch (InterruptedException | KeeperException ex) {
                    log.error("Listener Exception executeContention:{}", (Object)ex.getMessage(), (Object)ex);
                }
            }
        });
        if (canBegin) {
            try {
                this.action();
                this.done = true;
                this.callback();
            }
            catch (InterruptedException | KeeperException ex) {
                log.error("action Exception executeContention:{}", (Object)ex.getMessage(), (Object)ex);
            }
            provider.delete(contendNode);
        }
    }

    private boolean contend(String node, IProvider provider, ZookeeperEventListener zookeeperEventListener) throws KeeperException, InterruptedException {
        boolean result = false;
        try {
            provider.create(node, "1", CreateMode.EPHEMERAL);
            result = true;
        }
        catch (KeeperException.NodeExistsException ex) {
            log.info("contend not result");
            provider.exists(node, WatcherCreator.deleteWatcher(zookeeperEventListener));
        }
        return result;
    }

    public void waitDone() {
        while (!this.done) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException ex) {
                log.error("waitDone:{}", (Object)ex.getMessage(), (Object)ex);
            }
        }
    }

    public abstract void action() throws KeeperException, InterruptedException;

    public void callback() {
    }
}

