/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.orchestration.reg.newzk.client.cache;

import io.shardingsphere.orchestration.reg.newzk.client.cache.PathResolve;
import io.shardingsphere.orchestration.reg.newzk.client.utility.PathUtil;
import io.shardingsphere.orchestration.reg.newzk.client.utility.ZookeeperConstants;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class PathNode {
    private final Map<String, PathNode> children = new ConcurrentHashMap<String, PathNode>();
    private final String nodeKey;
    private String path;
    private byte[] value;

    PathNode(String key) {
        this(key, ZookeeperConstants.RELEASE_VALUE);
    }

    PathNode(String key, byte[] value) {
        this.nodeKey = key;
        this.value = value;
        this.path = key;
    }

    void attachChild(PathNode node) {
        this.children.put(node.nodeKey, node);
        node.setPath(PathUtil.getRealPath(this.path, node.getNodeKey()));
    }

    PathNode set(PathResolve pathResolve, String value) {
        if (pathResolve.isEnd()) {
            this.setValue(value.getBytes(ZookeeperConstants.UTF_8));
            return this;
        }
        pathResolve.next();
        if (this.children.containsKey(pathResolve.getCurrent())) {
            return this.children.get(pathResolve.getCurrent()).set(pathResolve, value);
        }
        PathNode result = new PathNode(pathResolve.getCurrent(), ZookeeperConstants.NOTHING_DATA);
        this.attachChild(result);
        result.set(pathResolve, value);
        return result;
    }

    PathNode get(PathResolve pathResolve) {
        pathResolve.next();
        if (this.children.containsKey(pathResolve.getCurrent())) {
            if (pathResolve.isEnd()) {
                return this.children.get(pathResolve.getCurrent());
            }
            return this.children.get(pathResolve.getCurrent()).get(pathResolve);
        }
        return null;
    }

    void delete(PathResolve pathResolve) {
        pathResolve.next();
        if (this.children.containsKey(pathResolve.getCurrent())) {
            if (pathResolve.isEnd()) {
                this.children.remove(pathResolve.getCurrent());
            } else {
                this.children.get(pathResolve.getCurrent()).delete(pathResolve);
            }
        }
    }

    public Map<String, PathNode> getChildren() {
        return this.children;
    }

    public String getNodeKey() {
        return this.nodeKey;
    }

    public String getPath() {
        return this.path;
    }

    public byte[] getValue() {
        return this.value;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setValue(byte[] value) {
        this.value = value;
    }
}

