/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.orchestration.reg.exception;

import io.shardingsphere.orchestration.reg.exception.RegException;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RegExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(RegExceptionHandler.class);

    public static void handleException(Exception cause) {
        if (null == cause) {
            return;
        }
        if (RegExceptionHandler.isIgnoredException(cause) || null != cause.getCause() && RegExceptionHandler.isIgnoredException(cause.getCause())) {
            log.debug("Ignored exception for: {}", (Object)cause.getMessage());
        } else if (cause instanceof InterruptedException) {
            Thread.currentThread().interrupt();
        } else {
            throw new RegException(cause);
        }
    }

    private static boolean isIgnoredException(Throwable cause) {
        return cause instanceof KeeperException.ConnectionLossException || cause instanceof KeeperException.NoNodeException || cause instanceof KeeperException.NodeExistsException;
    }

    private RegExceptionHandler() {
    }
}

