/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.orchestration.reg.etcd.internal.channel;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import io.grpc.Attributes;
import io.grpc.EquivalentAddressGroup;
import io.grpc.NameResolver;
import io.grpc.Status;
import io.grpc.internal.GrpcUtil;
import io.grpc.internal.SharedResourceHolder;
import java.beans.ConstructorProperties;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EtcdNameSolverFactory
extends NameResolver.Factory {
    private static final Logger log = LoggerFactory.getLogger(EtcdNameSolverFactory.class);
    private static final Pattern SCHEMAS = Pattern.compile("^(http|https)");
    private final String scheme;
    private final List<String> endpoints;
    private ExecutorService executor;
    private boolean shutdown;

    @Nullable
    public NameResolver newNameResolver(URI targetUri, Attributes params) {
        if (!this.scheme.equals(targetUri.getPath())) {
            return null;
        }
        return new NameResolver(){

            public String getServiceAuthority() {
                return EtcdNameSolverFactory.this.scheme;
            }

            public void start(NameResolver.Listener listener) {
                if (EtcdNameSolverFactory.this.shutdown) {
                    return;
                }
                ArrayList equivalentAddressGroups = Lists.newArrayList();
                for (String each : EtcdNameSolverFactory.this.endpoints) {
                    try {
                        URI uri = new URI(each.trim());
                        if (Strings.isNullOrEmpty((String)uri.getAuthority()) || !SCHEMAS.matcher(uri.getScheme()).matches()) continue;
                        InetSocketAddress inetSocketAddress = new InetSocketAddress(uri.getHost(), uri.getPort());
                        equivalentAddressGroups.add(new EquivalentAddressGroup((SocketAddress)inetSocketAddress));
                    }
                    catch (URISyntaxException ex) {
                        listener.onError(Status.INVALID_ARGUMENT);
                        log.warn("Ignored illegal endpoint, %s", (Object)ex.getMessage());
                    }
                }
                listener.onAddresses((List)equivalentAddressGroups, Attributes.EMPTY);
            }

            public void shutdown() {
                if (!EtcdNameSolverFactory.this.shutdown) {
                    EtcdNameSolverFactory.this.shutdown = true;
                    EtcdNameSolverFactory.this.executor = (ExecutorService)SharedResourceHolder.release((SharedResourceHolder.Resource)GrpcUtil.SHARED_CHANNEL_EXECUTOR, (Object)EtcdNameSolverFactory.this.executor);
                }
            }
        };
    }

    public String getDefaultScheme() {
        return this.scheme;
    }

    @ConstructorProperties(value={"scheme", "endpoints"})
    public EtcdNameSolverFactory(String scheme, List<String> endpoints) {
        this.scheme = scheme;
        this.endpoints = endpoints;
    }
}

