package etcdserverpb;

import static io.grpc.stub.ClientCalls.asyncUnaryCall;
import static io.grpc.stub.ClientCalls.asyncServerStreamingCall;
import static io.grpc.stub.ClientCalls.asyncClientStreamingCall;
import static io.grpc.stub.ClientCalls.asyncBidiStreamingCall;
import static io.grpc.stub.ClientCalls.blockingUnaryCall;
import static io.grpc.stub.ClientCalls.blockingServerStreamingCall;
import static io.grpc.stub.ClientCalls.futureUnaryCall;
import static io.grpc.MethodDescriptor.generateFullMethodName;
import static io.grpc.stub.ServerCalls.asyncUnaryCall;
import static io.grpc.stub.ServerCalls.asyncServerStreamingCall;
import static io.grpc.stub.ServerCalls.asyncClientStreamingCall;
import static io.grpc.stub.ServerCalls.asyncBidiStreamingCall;
import static io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall;
import static io.grpc.stub.ServerCalls.asyncUnimplementedStreamingCall;

/**
 */
@javax.annotation.Generated(
    value = "by gRPC proto compiler (version 1.7.0)",
    comments = "Source: etcd/etcdserver/etcdserverpb/rpc.proto")
public final class LeaseGrpc {

  private LeaseGrpc() {}

  public static final String SERVICE_NAME = "etcdserverpb.Lease";

  // Static method descriptors that strictly reflect the proto.
  @io.grpc.ExperimentalApi("https://github.com/grpc/grpc-java/issues/1901")
  public static final io.grpc.MethodDescriptor<etcdserverpb.Rpc.LeaseGrantRequest,
      etcdserverpb.Rpc.LeaseGrantResponse> METHOD_LEASE_GRANT =
      io.grpc.MethodDescriptor.<etcdserverpb.Rpc.LeaseGrantRequest, etcdserverpb.Rpc.LeaseGrantResponse>newBuilder()
          .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
          .setFullMethodName(generateFullMethodName(
              "etcdserverpb.Lease", "LeaseGrant"))
          .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
              etcdserverpb.Rpc.LeaseGrantRequest.getDefaultInstance()))
          .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
              etcdserverpb.Rpc.LeaseGrantResponse.getDefaultInstance()))
          .setSchemaDescriptor(new LeaseMethodDescriptorSupplier("LeaseGrant"))
          .build();
  @io.grpc.ExperimentalApi("https://github.com/grpc/grpc-java/issues/1901")
  public static final io.grpc.MethodDescriptor<etcdserverpb.Rpc.LeaseRevokeRequest,
      etcdserverpb.Rpc.LeaseRevokeResponse> METHOD_LEASE_REVOKE =
      io.grpc.MethodDescriptor.<etcdserverpb.Rpc.LeaseRevokeRequest, etcdserverpb.Rpc.LeaseRevokeResponse>newBuilder()
          .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
          .setFullMethodName(generateFullMethodName(
              "etcdserverpb.Lease", "LeaseRevoke"))
          .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
              etcdserverpb.Rpc.LeaseRevokeRequest.getDefaultInstance()))
          .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
              etcdserverpb.Rpc.LeaseRevokeResponse.getDefaultInstance()))
          .setSchemaDescriptor(new LeaseMethodDescriptorSupplier("LeaseRevoke"))
          .build();
  @io.grpc.ExperimentalApi("https://github.com/grpc/grpc-java/issues/1901")
  public static final io.grpc.MethodDescriptor<etcdserverpb.Rpc.LeaseKeepAliveRequest,
      etcdserverpb.Rpc.LeaseKeepAliveResponse> METHOD_LEASE_KEEP_ALIVE =
      io.grpc.MethodDescriptor.<etcdserverpb.Rpc.LeaseKeepAliveRequest, etcdserverpb.Rpc.LeaseKeepAliveResponse>newBuilder()
          .setType(io.grpc.MethodDescriptor.MethodType.BIDI_STREAMING)
          .setFullMethodName(generateFullMethodName(
              "etcdserverpb.Lease", "LeaseKeepAlive"))
          .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
              etcdserverpb.Rpc.LeaseKeepAliveRequest.getDefaultInstance()))
          .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
              etcdserverpb.Rpc.LeaseKeepAliveResponse.getDefaultInstance()))
          .setSchemaDescriptor(new LeaseMethodDescriptorSupplier("LeaseKeepAlive"))
          .build();
  @io.grpc.ExperimentalApi("https://github.com/grpc/grpc-java/issues/1901")
  public static final io.grpc.MethodDescriptor<etcdserverpb.Rpc.LeaseTimeToLiveRequest,
      etcdserverpb.Rpc.LeaseTimeToLiveResponse> METHOD_LEASE_TIME_TO_LIVE =
      io.grpc.MethodDescriptor.<etcdserverpb.Rpc.LeaseTimeToLiveRequest, etcdserverpb.Rpc.LeaseTimeToLiveResponse>newBuilder()
          .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
          .setFullMethodName(generateFullMethodName(
              "etcdserverpb.Lease", "LeaseTimeToLive"))
          .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
              etcdserverpb.Rpc.LeaseTimeToLiveRequest.getDefaultInstance()))
          .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
              etcdserverpb.Rpc.LeaseTimeToLiveResponse.getDefaultInstance()))
          .setSchemaDescriptor(new LeaseMethodDescriptorSupplier("LeaseTimeToLive"))
          .build();

  /**
   * Creates a new async stub that supports all call types for the service
   */
  public static LeaseStub newStub(io.grpc.Channel channel) {
    return new LeaseStub(channel);
  }

  /**
   * Creates a new blocking-style stub that supports unary and streaming output calls on the service
   */
  public static LeaseBlockingStub newBlockingStub(
      io.grpc.Channel channel) {
    return new LeaseBlockingStub(channel);
  }

  /**
   * Creates a new ListenableFuture-style stub that supports unary calls on the service
   */
  public static LeaseFutureStub newFutureStub(
      io.grpc.Channel channel) {
    return new LeaseFutureStub(channel);
  }

  /**
   */
  public static abstract class LeaseImplBase implements io.grpc.BindableService {

    /**
     * <pre>
     * LeaseGrant creates a lease which expires if the server does not receive a keepAlive
     * within a given time to live period. All keys attached to the lease will be expired and
     * deleted if the lease expires. Each expired key generates a delete event in the event history.
     * </pre>
     */
    public void leaseGrant(etcdserverpb.Rpc.LeaseGrantRequest request,
        io.grpc.stub.StreamObserver<etcdserverpb.Rpc.LeaseGrantResponse> responseObserver) {
      asyncUnimplementedUnaryCall(METHOD_LEASE_GRANT, responseObserver);
    }

    /**
     * <pre>
     * LeaseRevoke revokes a lease. All keys attached to the lease will expire and be deleted.
     * </pre>
     */
    public void leaseRevoke(etcdserverpb.Rpc.LeaseRevokeRequest request,
        io.grpc.stub.StreamObserver<etcdserverpb.Rpc.LeaseRevokeResponse> responseObserver) {
      asyncUnimplementedUnaryCall(METHOD_LEASE_REVOKE, responseObserver);
    }

    /**
     * <pre>
     * LeaseKeepAlive keeps the lease alive by streaming keep alive requests from the client
     * to the server and streaming keep alive responses from the server to the client.
     * </pre>
     */
    public io.grpc.stub.StreamObserver<etcdserverpb.Rpc.LeaseKeepAliveRequest> leaseKeepAlive(
        io.grpc.stub.StreamObserver<etcdserverpb.Rpc.LeaseKeepAliveResponse> responseObserver) {
      return asyncUnimplementedStreamingCall(METHOD_LEASE_KEEP_ALIVE, responseObserver);
    }

    /**
     * <pre>
     * LeaseTimeToLive retrieves lease information.
     * </pre>
     */
    public void leaseTimeToLive(etcdserverpb.Rpc.LeaseTimeToLiveRequest request,
        io.grpc.stub.StreamObserver<etcdserverpb.Rpc.LeaseTimeToLiveResponse> responseObserver) {
      asyncUnimplementedUnaryCall(METHOD_LEASE_TIME_TO_LIVE, responseObserver);
    }

    @java.lang.Override public final io.grpc.ServerServiceDefinition bindService() {
      return io.grpc.ServerServiceDefinition.builder(getServiceDescriptor())
          .addMethod(
            METHOD_LEASE_GRANT,
            asyncUnaryCall(
              new MethodHandlers<
                etcdserverpb.Rpc.LeaseGrantRequest,
                etcdserverpb.Rpc.LeaseGrantResponse>(
                  this, METHODID_LEASE_GRANT)))
          .addMethod(
            METHOD_LEASE_REVOKE,
            asyncUnaryCall(
              new MethodHandlers<
                etcdserverpb.Rpc.LeaseRevokeRequest,
                etcdserverpb.Rpc.LeaseRevokeResponse>(
                  this, METHODID_LEASE_REVOKE)))
          .addMethod(
            METHOD_LEASE_KEEP_ALIVE,
            asyncBidiStreamingCall(
              new MethodHandlers<
                etcdserverpb.Rpc.LeaseKeepAliveRequest,
                etcdserverpb.Rpc.LeaseKeepAliveResponse>(
                  this, METHODID_LEASE_KEEP_ALIVE)))
          .addMethod(
            METHOD_LEASE_TIME_TO_LIVE,
            asyncUnaryCall(
              new MethodHandlers<
                etcdserverpb.Rpc.LeaseTimeToLiveRequest,
                etcdserverpb.Rpc.LeaseTimeToLiveResponse>(
                  this, METHODID_LEASE_TIME_TO_LIVE)))
          .build();
    }
  }

  /**
   */
  public static final class LeaseStub extends io.grpc.stub.AbstractStub<LeaseStub> {
    private LeaseStub(io.grpc.Channel channel) {
      super(channel);
    }

    private LeaseStub(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected LeaseStub build(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      return new LeaseStub(channel, callOptions);
    }

    /**
     * <pre>
     * LeaseGrant creates a lease which expires if the server does not receive a keepAlive
     * within a given time to live period. All keys attached to the lease will be expired and
     * deleted if the lease expires. Each expired key generates a delete event in the event history.
     * </pre>
     */
    public void leaseGrant(etcdserverpb.Rpc.LeaseGrantRequest request,
        io.grpc.stub.StreamObserver<etcdserverpb.Rpc.LeaseGrantResponse> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(METHOD_LEASE_GRANT, getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * LeaseRevoke revokes a lease. All keys attached to the lease will expire and be deleted.
     * </pre>
     */
    public void leaseRevoke(etcdserverpb.Rpc.LeaseRevokeRequest request,
        io.grpc.stub.StreamObserver<etcdserverpb.Rpc.LeaseRevokeResponse> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(METHOD_LEASE_REVOKE, getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * LeaseKeepAlive keeps the lease alive by streaming keep alive requests from the client
     * to the server and streaming keep alive responses from the server to the client.
     * </pre>
     */
    public io.grpc.stub.StreamObserver<etcdserverpb.Rpc.LeaseKeepAliveRequest> leaseKeepAlive(
        io.grpc.stub.StreamObserver<etcdserverpb.Rpc.LeaseKeepAliveResponse> responseObserver) {
      return asyncBidiStreamingCall(
          getChannel().newCall(METHOD_LEASE_KEEP_ALIVE, getCallOptions()), responseObserver);
    }

    /**
     * <pre>
     * LeaseTimeToLive retrieves lease information.
     * </pre>
     */
    public void leaseTimeToLive(etcdserverpb.Rpc.LeaseTimeToLiveRequest request,
        io.grpc.stub.StreamObserver<etcdserverpb.Rpc.LeaseTimeToLiveResponse> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(METHOD_LEASE_TIME_TO_LIVE, getCallOptions()), request, responseObserver);
    }
  }

  /**
   */
  public static final class LeaseBlockingStub extends io.grpc.stub.AbstractStub<LeaseBlockingStub> {
    private LeaseBlockingStub(io.grpc.Channel channel) {
      super(channel);
    }

    private LeaseBlockingStub(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected LeaseBlockingStub build(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      return new LeaseBlockingStub(channel, callOptions);
    }

    /**
     * <pre>
     * LeaseGrant creates a lease which expires if the server does not receive a keepAlive
     * within a given time to live period. All keys attached to the lease will be expired and
     * deleted if the lease expires. Each expired key generates a delete event in the event history.
     * </pre>
     */
    public etcdserverpb.Rpc.LeaseGrantResponse leaseGrant(etcdserverpb.Rpc.LeaseGrantRequest request) {
      return blockingUnaryCall(
          getChannel(), METHOD_LEASE_GRANT, getCallOptions(), request);
    }

    /**
     * <pre>
     * LeaseRevoke revokes a lease. All keys attached to the lease will expire and be deleted.
     * </pre>
     */
    public etcdserverpb.Rpc.LeaseRevokeResponse leaseRevoke(etcdserverpb.Rpc.LeaseRevokeRequest request) {
      return blockingUnaryCall(
          getChannel(), METHOD_LEASE_REVOKE, getCallOptions(), request);
    }

    /**
     * <pre>
     * LeaseTimeToLive retrieves lease information.
     * </pre>
     */
    public etcdserverpb.Rpc.LeaseTimeToLiveResponse leaseTimeToLive(etcdserverpb.Rpc.LeaseTimeToLiveRequest request) {
      return blockingUnaryCall(
          getChannel(), METHOD_LEASE_TIME_TO_LIVE, getCallOptions(), request);
    }
  }

  /**
   */
  public static final class LeaseFutureStub extends io.grpc.stub.AbstractStub<LeaseFutureStub> {
    private LeaseFutureStub(io.grpc.Channel channel) {
      super(channel);
    }

    private LeaseFutureStub(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected LeaseFutureStub build(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      return new LeaseFutureStub(channel, callOptions);
    }

    /**
     * <pre>
     * LeaseGrant creates a lease which expires if the server does not receive a keepAlive
     * within a given time to live period. All keys attached to the lease will be expired and
     * deleted if the lease expires. Each expired key generates a delete event in the event history.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<etcdserverpb.Rpc.LeaseGrantResponse> leaseGrant(
        etcdserverpb.Rpc.LeaseGrantRequest request) {
      return futureUnaryCall(
          getChannel().newCall(METHOD_LEASE_GRANT, getCallOptions()), request);
    }

    /**
     * <pre>
     * LeaseRevoke revokes a lease. All keys attached to the lease will expire and be deleted.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<etcdserverpb.Rpc.LeaseRevokeResponse> leaseRevoke(
        etcdserverpb.Rpc.LeaseRevokeRequest request) {
      return futureUnaryCall(
          getChannel().newCall(METHOD_LEASE_REVOKE, getCallOptions()), request);
    }

    /**
     * <pre>
     * LeaseTimeToLive retrieves lease information.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<etcdserverpb.Rpc.LeaseTimeToLiveResponse> leaseTimeToLive(
        etcdserverpb.Rpc.LeaseTimeToLiveRequest request) {
      return futureUnaryCall(
          getChannel().newCall(METHOD_LEASE_TIME_TO_LIVE, getCallOptions()), request);
    }
  }

  private static final int METHODID_LEASE_GRANT = 0;
  private static final int METHODID_LEASE_REVOKE = 1;
  private static final int METHODID_LEASE_TIME_TO_LIVE = 2;
  private static final int METHODID_LEASE_KEEP_ALIVE = 3;

  private static final class MethodHandlers<Req, Resp> implements
      io.grpc.stub.ServerCalls.UnaryMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.ServerStreamingMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.ClientStreamingMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.BidiStreamingMethod<Req, Resp> {
    private final LeaseImplBase serviceImpl;
    private final int methodId;

    MethodHandlers(LeaseImplBase serviceImpl, int methodId) {
      this.serviceImpl = serviceImpl;
      this.methodId = methodId;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public void invoke(Req request, io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        case METHODID_LEASE_GRANT:
          serviceImpl.leaseGrant((etcdserverpb.Rpc.LeaseGrantRequest) request,
              (io.grpc.stub.StreamObserver<etcdserverpb.Rpc.LeaseGrantResponse>) responseObserver);
          break;
        case METHODID_LEASE_REVOKE:
          serviceImpl.leaseRevoke((etcdserverpb.Rpc.LeaseRevokeRequest) request,
              (io.grpc.stub.StreamObserver<etcdserverpb.Rpc.LeaseRevokeResponse>) responseObserver);
          break;
        case METHODID_LEASE_TIME_TO_LIVE:
          serviceImpl.leaseTimeToLive((etcdserverpb.Rpc.LeaseTimeToLiveRequest) request,
              (io.grpc.stub.StreamObserver<etcdserverpb.Rpc.LeaseTimeToLiveResponse>) responseObserver);
          break;
        default:
          throw new AssertionError();
      }
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public io.grpc.stub.StreamObserver<Req> invoke(
        io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        case METHODID_LEASE_KEEP_ALIVE:
          return (io.grpc.stub.StreamObserver<Req>) serviceImpl.leaseKeepAlive(
              (io.grpc.stub.StreamObserver<etcdserverpb.Rpc.LeaseKeepAliveResponse>) responseObserver);
        default:
          throw new AssertionError();
      }
    }
  }

  private static abstract class LeaseBaseDescriptorSupplier
      implements io.grpc.protobuf.ProtoFileDescriptorSupplier, io.grpc.protobuf.ProtoServiceDescriptorSupplier {
    LeaseBaseDescriptorSupplier() {}

    @java.lang.Override
    public com.google.protobuf.Descriptors.FileDescriptor getFileDescriptor() {
      return etcdserverpb.Rpc.getDescriptor();
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.ServiceDescriptor getServiceDescriptor() {
      return getFileDescriptor().findServiceByName("Lease");
    }
  }

  private static final class LeaseFileDescriptorSupplier
      extends LeaseBaseDescriptorSupplier {
    LeaseFileDescriptorSupplier() {}
  }

  private static final class LeaseMethodDescriptorSupplier
      extends LeaseBaseDescriptorSupplier
      implements io.grpc.protobuf.ProtoMethodDescriptorSupplier {
    private final String methodName;

    LeaseMethodDescriptorSupplier(String methodName) {
      this.methodName = methodName;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.MethodDescriptor getMethodDescriptor() {
      return getServiceDescriptor().findMethodByName(methodName);
    }
  }

  private static volatile io.grpc.ServiceDescriptor serviceDescriptor;

  public static io.grpc.ServiceDescriptor getServiceDescriptor() {
    io.grpc.ServiceDescriptor result = serviceDescriptor;
    if (result == null) {
      synchronized (LeaseGrpc.class) {
        result = serviceDescriptor;
        if (result == null) {
          serviceDescriptor = result = io.grpc.ServiceDescriptor.newBuilder(SERVICE_NAME)
              .setSchemaDescriptor(new LeaseFileDescriptorSupplier())
              .addMethod(METHOD_LEASE_GRANT)
              .addMethod(METHOD_LEASE_REVOKE)
              .addMethod(METHOD_LEASE_KEEP_ALIVE)
              .addMethod(METHOD_LEASE_TIME_TO_LIVE)
              .build();
        }
      }
    }
    return result;
  }
}
