/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.orchestration.reg.newzk.client.zookeeper.transaction;

import io.shardingsphere.orchestration.reg.newzk.client.utility.PathUtil;
import io.shardingsphere.orchestration.reg.newzk.client.zookeeper.base.Holder;
import io.shardingsphere.orchestration.reg.newzk.client.zookeeper.transaction.BaseTransaction;
import java.util.List;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.OpResult;
import org.apache.zookeeper.Transaction;
import org.apache.zookeeper.data.ACL;

public final class ZooKeeperTransaction
extends BaseTransaction {
    private final String rootNode;
    private final Transaction transaction;

    public ZooKeeperTransaction(String root, Holder holder) {
        this.rootNode = root;
        this.transaction = holder.getZooKeeper().transaction();
    }

    @Override
    public ZooKeeperTransaction create(String path, byte[] data, List<ACL> acl, CreateMode createMode) {
        this.transaction.create(PathUtil.getRealPath(this.rootNode, path), data, acl, createMode);
        return this;
    }

    @Override
    public ZooKeeperTransaction delete(String path) {
        return this.delete(path, -1);
    }

    @Override
    public ZooKeeperTransaction delete(String path, int version) {
        this.transaction.delete(PathUtil.getRealPath(this.rootNode, path), version);
        return this;
    }

    @Override
    public ZooKeeperTransaction check(String path) {
        return this.check(path, -1);
    }

    @Override
    public ZooKeeperTransaction check(String path, int version) {
        this.transaction.check(PathUtil.getRealPath(this.rootNode, path), version);
        return this;
    }

    @Override
    public ZooKeeperTransaction setData(String path, byte[] data) {
        return this.setData(path, data, -1);
    }

    @Override
    public ZooKeeperTransaction setData(String path, byte[] data, int version) {
        this.transaction.setData(PathUtil.getRealPath(this.rootNode, path), data, version);
        return this;
    }

    @Override
    public List<OpResult> commit() throws InterruptedException, KeeperException {
        return this.transaction.commit();
    }
}

