/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.orchestration.reg.newzk.client.zookeeper.strategy;

import io.shardingsphere.orchestration.reg.newzk.client.action.IProvider;
import io.shardingsphere.orchestration.reg.newzk.client.retry.DelayRetryPolicy;
import io.shardingsphere.orchestration.reg.newzk.client.retry.RetryCallable;
import io.shardingsphere.orchestration.reg.newzk.client.retry.RetryResultCallable;
import io.shardingsphere.orchestration.reg.newzk.client.zookeeper.strategy.UsualStrategy;
import java.util.List;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Watcher;

public class SyncRetryStrategy
extends UsualStrategy {
    private final DelayRetryPolicy delayRetryPolicy;

    public SyncRetryStrategy(IProvider provider, DelayRetryPolicy delayRetryPolicy) {
        super(provider);
        this.delayRetryPolicy = null == delayRetryPolicy ? DelayRetryPolicy.defaultDelayPolicy() : delayRetryPolicy;
    }

    @Override
    public byte[] getData(final String key) throws KeeperException, InterruptedException {
        RetryResultCallable<byte[]> retryCallable = new RetryResultCallable<byte[]>(this.getProvider(), this.delayRetryPolicy){

            @Override
            public void call() throws KeeperException, InterruptedException {
                this.setResult(this.getProvider().getData(this.getProvider().getRealPath(key)));
            }
        };
        return (byte[])retryCallable.getResult();
    }

    @Override
    public boolean checkExists(final String key) throws KeeperException, InterruptedException {
        RetryResultCallable<Boolean> retryCallable = new RetryResultCallable<Boolean>(this.getProvider(), this.delayRetryPolicy){

            @Override
            public void call() throws KeeperException, InterruptedException {
                this.setResult(this.getProvider().exists(this.getProvider().getRealPath(key)));
            }
        };
        return (Boolean)retryCallable.getResult();
    }

    @Override
    public boolean checkExists(final String key, final Watcher watcher) throws KeeperException, InterruptedException {
        RetryResultCallable<Boolean> retryCallable = new RetryResultCallable<Boolean>(this.getProvider(), this.delayRetryPolicy){

            @Override
            public void call() throws KeeperException, InterruptedException {
                this.setResult(this.getProvider().exists(this.getProvider().getRealPath(key), watcher));
            }
        };
        return (Boolean)retryCallable.getResult();
    }

    @Override
    public List<String> getChildren(final String key) throws KeeperException, InterruptedException {
        RetryResultCallable<List<String>> retryCallable = new RetryResultCallable<List<String>>(this.getProvider(), this.delayRetryPolicy){

            @Override
            public void call() throws KeeperException, InterruptedException {
                this.setResult(this.getProvider().getChildren(this.getProvider().getRealPath(key)));
            }
        };
        return (List)retryCallable.getResult();
    }

    @Override
    public void createCurrentOnly(final String key, final String value, final CreateMode createMode) throws KeeperException, InterruptedException {
        RetryCallable retryCallable = new RetryCallable(this.getProvider(), this.delayRetryPolicy){

            @Override
            public void call() throws KeeperException, InterruptedException {
                this.getProvider().create(this.getProvider().getRealPath(key), value, createMode);
            }
        };
        retryCallable.exec();
    }

    @Override
    public void update(final String key, final String value) throws KeeperException, InterruptedException {
        RetryCallable retryCallable = new RetryCallable(this.getProvider(), this.delayRetryPolicy){

            @Override
            public void call() throws KeeperException, InterruptedException {
                this.getProvider().update(this.getProvider().getRealPath(key), value);
            }
        };
        retryCallable.exec();
    }

    @Override
    public void deleteOnlyCurrent(final String key) throws KeeperException, InterruptedException {
        RetryCallable retryCallable = new RetryCallable(this.getProvider(), this.delayRetryPolicy){

            @Override
            public void call() throws KeeperException, InterruptedException {
                this.getProvider().delete(this.getProvider().getRealPath(key));
            }
        };
        retryCallable.exec();
    }

    @Override
    public void createAllNeedPath(final String key, final String value, final CreateMode createMode) throws KeeperException, InterruptedException {
        RetryCallable retryCallable = new RetryCallable(this.getProvider(), this.delayRetryPolicy){

            @Override
            public void call() throws KeeperException, InterruptedException {
                new UsualStrategy(this.getProvider()).createAllNeedPath(key, value, createMode);
            }
        };
        retryCallable.exec();
    }

    @Override
    public void deleteAllChildren(final String key) throws KeeperException, InterruptedException {
        RetryCallable retryCallable = new RetryCallable(this.getProvider(), this.delayRetryPolicy){

            @Override
            public void call() throws KeeperException, InterruptedException {
                new UsualStrategy(this.getProvider()).deleteAllChildren(key);
            }
        };
        retryCallable.exec();
    }

    @Override
    public void deleteCurrentBranch(final String key) throws KeeperException, InterruptedException {
        RetryCallable retryCallable = new RetryCallable(this.getProvider(), this.delayRetryPolicy){

            @Override
            public void call() throws KeeperException, InterruptedException {
                new UsualStrategy(this.getProvider()).deleteCurrentBranch(key);
            }
        };
        retryCallable.exec();
    }

    protected DelayRetryPolicy getDelayRetryPolicy() {
        return this.delayRetryPolicy;
    }
}

