/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.orchestration.reg.newzk.client.zookeeper.strategy;

import io.shardingsphere.orchestration.reg.newzk.client.action.ContentionCallback;
import io.shardingsphere.orchestration.reg.newzk.client.action.IProvider;
import io.shardingsphere.orchestration.reg.newzk.client.election.LeaderElection;
import io.shardingsphere.orchestration.reg.newzk.client.utility.PathUtil;
import io.shardingsphere.orchestration.reg.newzk.client.zookeeper.strategy.UsualStrategy;
import java.util.List;
import java.util.Stack;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContentionStrategy
extends UsualStrategy {
    private static final Logger log = LoggerFactory.getLogger(ContentionStrategy.class);

    public ContentionStrategy(IProvider provider) {
        super(provider);
    }

    @Override
    public final void getData(final String key, final AsyncCallback.DataCallback callback, final Object ctx) throws KeeperException, InterruptedException {
        this.getProvider().executeContention(new LeaderElection(){

            @Override
            public void action() throws KeeperException, InterruptedException {
                ContentionStrategy.this.getProvider().getData(ContentionStrategy.this.getProvider().getRealPath(key), callback, ctx);
            }
        });
    }

    @Override
    public final void createCurrentOnly(String key, String value, CreateMode createMode) throws KeeperException, InterruptedException {
        LeaderElection election = this.buildCreateElection(key, value, createMode, null);
        this.getProvider().executeContention(election);
        election.waitDone();
    }

    private LeaderElection buildCreateElection(final String key, final String value, final CreateMode createMode, final ContentionCallback contentionCallback) {
        return new LeaderElection(){

            @Override
            public void action() throws KeeperException, InterruptedException {
                ContentionStrategy.this.getProvider().create(ContentionStrategy.this.getProvider().getRealPath(key), value, createMode);
            }

            @Override
            public void callback() {
                if (null != contentionCallback) {
                    contentionCallback.processResult();
                }
            }
        };
    }

    @Override
    public final void update(String key, String value) throws KeeperException, InterruptedException {
        LeaderElection election = this.buildUpdateElection(key, value, null);
        this.getProvider().executeContention(election);
        election.waitDone();
    }

    private LeaderElection buildUpdateElection(final String key, final String value, final ContentionCallback contentionCallback) {
        return new LeaderElection(){

            @Override
            public void action() throws KeeperException, InterruptedException {
                ContentionStrategy.this.getProvider().update(ContentionStrategy.this.getProvider().getRealPath(key), value);
            }

            @Override
            public void callback() {
                if (null != contentionCallback) {
                    contentionCallback.processResult();
                }
            }
        };
    }

    @Override
    public final void deleteOnlyCurrent(String key) throws KeeperException, InterruptedException {
        LeaderElection election = this.buildDeleteElection(key, null);
        this.getProvider().executeContention(election);
        election.waitDone();
    }

    @Override
    public final void deleteOnlyCurrent(final String key, final AsyncCallback.VoidCallback callback, final Object ctx) throws KeeperException, InterruptedException {
        this.getProvider().executeContention(new LeaderElection(){

            @Override
            public void action() throws KeeperException, InterruptedException {
                ContentionStrategy.this.getProvider().delete(ContentionStrategy.this.getProvider().getRealPath(key), callback, ctx);
            }
        });
    }

    private LeaderElection buildDeleteElection(final String key, final ContentionCallback contentionCallback) {
        return new LeaderElection(){

            @Override
            public void action() throws KeeperException, InterruptedException {
                ContentionStrategy.this.getProvider().delete(ContentionStrategy.this.getProvider().getRealPath(key));
            }

            @Override
            public void callback() {
                if (null != contentionCallback) {
                    contentionCallback.processResult();
                }
            }
        };
    }

    @Override
    public void createAllNeedPath(String key, String value, CreateMode createMode) throws KeeperException, InterruptedException {
        LeaderElection election = this.buildCreateAllNeedElection(key, value, createMode, null);
        this.getProvider().executeContention(election);
        election.waitDone();
    }

    private LeaderElection buildCreateAllNeedElection(final String key, final String value, final CreateMode createMode, final ContentionCallback contentionCallback) {
        return new LeaderElection(){

            @Override
            public void action() throws KeeperException, InterruptedException {
                ContentionStrategy.this.createBegin(ContentionStrategy.this.getProvider().getRealPath(key), value, createMode);
            }

            @Override
            public void callback() {
                if (null != contentionCallback) {
                    contentionCallback.processResult();
                }
            }
        };
    }

    private void createBegin(String key, String value, CreateMode createMode) throws KeeperException, InterruptedException {
        if (!key.contains("/")) {
            this.getProvider().create(key, value, createMode);
            return;
        }
        List<String> nodes = this.getProvider().getNecessaryPaths(key);
        for (int i = 0; i < nodes.size(); ++i) {
            if (this.getProvider().exists(nodes.get(i))) continue;
            if (i == nodes.size() - 1) {
                this.getProvider().create(nodes.get(i), value, createMode);
                continue;
            }
            this.getProvider().create(nodes.get(i), "", createMode);
        }
    }

    @Override
    public void deleteAllChildren(final String key) throws KeeperException, InterruptedException {
        this.getProvider().executeContention(new LeaderElection(){

            @Override
            public void action() throws KeeperException, InterruptedException {
                ContentionStrategy.this.deleteChildren(ContentionStrategy.this.getProvider().getRealPath(key), true);
            }
        });
    }

    private void deleteChildren(String key, boolean deleteCurrentNode) throws KeeperException, InterruptedException {
        List<String> children = this.getProvider().getChildren(key);
        for (String aChildren : children) {
            String child = PathUtil.getRealPath(key, aChildren);
            if (!this.getProvider().exists(child)) continue;
            this.deleteChildren(child, true);
        }
        if (deleteCurrentNode) {
            this.getProvider().delete(key);
        }
    }

    @Override
    public void deleteCurrentBranch(final String key) throws KeeperException, InterruptedException {
        this.getProvider().executeContention(new LeaderElection(){

            @Override
            public void action() throws KeeperException, InterruptedException {
                ContentionStrategy.this.deleteBranch(ContentionStrategy.this.getProvider().getRealPath(key));
            }
        });
    }

    private void deleteBranch(String key) throws KeeperException, InterruptedException {
        this.deleteChildren(key, false);
        Stack<String> pathStack = this.getProvider().getDeletingPaths(key);
        while (!pathStack.empty()) {
            String node = pathStack.pop();
            if (this.getProvider().exists(node)) {
                try {
                    this.getProvider().delete(node);
                }
                catch (KeeperException.NotEmptyException e) {
                    log.warn("deleteBranch {} exist other children: {}", (Object)node, this.getChildren(node));
                    return;
                }
            }
            log.info("deleteBranch node not exist: {}", (Object)node);
        }
    }
}

