/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.orchestration.reg.newzk.client.zookeeper.provider;

import io.shardingsphere.orchestration.reg.newzk.client.action.IProvider;
import io.shardingsphere.orchestration.reg.newzk.client.election.LeaderElection;
import io.shardingsphere.orchestration.reg.newzk.client.utility.PathUtil;
import io.shardingsphere.orchestration.reg.newzk.client.utility.ZookeeperConstants;
import io.shardingsphere.orchestration.reg.newzk.client.zookeeper.base.Holder;
import io.shardingsphere.orchestration.reg.newzk.client.zookeeper.transaction.BaseTransaction;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.util.List;
import java.util.Stack;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.data.ACL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseProvider
implements IProvider {
    private static final Logger log = LoggerFactory.getLogger(BaseProvider.class);
    private final String rootNode;
    private final Holder holder;
    private final boolean watched;
    private final List<ACL> authorities;

    @Override
    public final String getDataString(String key) throws KeeperException, InterruptedException {
        return new String(this.getData(key));
    }

    @Override
    public final byte[] getData(String key) throws KeeperException, InterruptedException {
        return this.holder.getZooKeeper().getData(key, this.watched, null);
    }

    @Override
    public final void getData(String key, AsyncCallback.DataCallback callback, Object ctx) {
        this.holder.getZooKeeper().getData(key, this.watched, callback, ctx);
    }

    @Override
    public final boolean exists(String key) throws KeeperException, InterruptedException {
        return null != this.holder.getZooKeeper().exists(key, this.watched);
    }

    @Override
    public final boolean exists(String key, Watcher watcher) throws KeeperException, InterruptedException {
        return null != this.holder.getZooKeeper().exists(key, watcher);
    }

    @Override
    public final List<String> getChildren(String key) throws KeeperException, InterruptedException {
        return this.holder.getZooKeeper().getChildren(key, this.watched);
    }

    @Override
    public final void create(String key, String value, CreateMode createMode) throws KeeperException, InterruptedException {
        if (this.exists(key)) {
            return;
        }
        this.holder.getZooKeeper().create(key, value.getBytes(ZookeeperConstants.UTF_8), this.authorities, createMode);
    }

    @Override
    public final boolean update(String key, String value) throws KeeperException, InterruptedException {
        if (this.exists(key)) {
            this.holder.getZooKeeper().setData(key, value.getBytes(ZookeeperConstants.UTF_8), -1);
            return true;
        }
        return false;
    }

    @Override
    public final void delete(String key) throws KeeperException, InterruptedException {
        this.holder.getZooKeeper().delete(key, -1);
    }

    @Override
    public final void delete(String key, AsyncCallback.VoidCallback callback, Object ctx) {
        this.holder.getZooKeeper().delete(key, -1, callback, ctx);
    }

    @Override
    public final String getRealPath(String path) {
        return PathUtil.getRealPath(this.rootNode, path);
    }

    @Override
    public final List<String> getNecessaryPaths(String key) {
        List<String> nodes = PathUtil.getPathOrderNodes(this.rootNode, key);
        nodes.remove(this.rootNode);
        return nodes;
    }

    @Override
    public final Stack<String> getDeletingPaths(String key) {
        return PathUtil.getPathReverseNodes(this.rootNode, key);
    }

    @Override
    public final void executeContention(LeaderElection election) throws KeeperException, InterruptedException {
        this.executeContention(this.rootNode, election);
    }

    private void executeContention(String nodeBeCompete, LeaderElection election) throws KeeperException, InterruptedException {
        election.executeContention(nodeBeCompete, this);
    }

    @Override
    public final void resetConnection() {
        try {
            this.holder.reset();
        }
        catch (IOException | InterruptedException ex) {
            log.error("resetConnection Exception: {}", (Object)ex.getMessage(), (Object)ex);
        }
    }

    @Override
    public BaseTransaction transaction() {
        return new BaseTransaction();
    }

    @ConstructorProperties(value={"rootNode", "holder", "watched", "authorities"})
    public BaseProvider(String rootNode, Holder holder, boolean watched, List<ACL> authorities) {
        this.rootNode = rootNode;
        this.holder = holder;
        this.watched = watched;
        this.authorities = authorities;
    }

    public String getRootNode() {
        return this.rootNode;
    }

    public Holder getHolder() {
        return this.holder;
    }

    protected boolean isWatched() {
        return this.watched;
    }

    protected List<ACL> getAuthorities() {
        return this.authorities;
    }
}

