/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.orchestration.reg.newzk.client.zookeeper.base;

import com.google.common.base.Strings;
import io.shardingsphere.orchestration.reg.newzk.client.action.IClient;
import io.shardingsphere.orchestration.reg.newzk.client.utility.PathUtil;
import io.shardingsphere.orchestration.reg.newzk.client.utility.ZookeeperConstants;
import io.shardingsphere.orchestration.reg.newzk.client.zookeeper.base.BaseContext;
import io.shardingsphere.orchestration.reg.newzk.client.zookeeper.base.Holder;
import io.shardingsphere.orchestration.reg.newzk.client.zookeeper.section.StrategyType;
import io.shardingsphere.orchestration.reg.newzk.client.zookeeper.section.WatcherCreator;
import io.shardingsphere.orchestration.reg.newzk.client.zookeeper.section.ZookeeperEventListener;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.data.ACL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseClient
implements IClient {
    private static final Logger log = LoggerFactory.getLogger(BaseClient.class);
    private static final int CIRCLE_WAIT = 30;
    private List<ACL> authorities;
    private boolean rootExist;
    private Holder holder;
    private String rootNode = "/InitValue";
    private BaseContext context;

    protected BaseClient(BaseContext context) {
        this.context = context;
    }

    @Override
    public void start() throws IOException, InterruptedException {
        this.prepareStart();
        this.holder.start();
    }

    @Override
    public synchronized boolean start(int waitingTime, TimeUnit timeUnit) throws InterruptedException, IOException {
        this.prepareStart();
        this.holder.start(waitingTime, timeUnit);
        return this.holder.isConnected();
    }

    private void prepareStart() {
        this.holder = new Holder(this.getContext());
        this.useExecStrategy(StrategyType.USUAL);
    }

    @Override
    public synchronized boolean blockUntilConnected(int waitingTime, TimeUnit timeUnit) throws InterruptedException {
        long maxWait;
        long l = maxWait = timeUnit != null ? TimeUnit.MILLISECONDS.convert(waitingTime, timeUnit) : 0L;
        while (!this.holder.isConnected()) {
            long waitTime = maxWait - 30L;
            if (waitTime <= 0L) {
                return this.holder.isConnected();
            }
            this.wait(30L);
        }
        return true;
    }

    @Override
    public void close() {
        this.context.close();
        try {
            if (this.rootExist) {
                this.deleteNamespace();
            }
        }
        catch (InterruptedException | KeeperException ex) {
            log.error("zk client close delete root error:{}", (Object)ex.getMessage(), (Object)ex);
        }
        this.holder.close();
    }

    void registerWatch(ZookeeperEventListener globalZookeeperEventListener) {
        if (this.context.getGlobalZookeeperEventListener() != null) {
            log.warn("global listener can only register one");
            return;
        }
        this.context.setGlobalZookeeperEventListener(globalZookeeperEventListener);
    }

    @Override
    public final void registerWatch(String key, ZookeeperEventListener zookeeperEventListener) {
        String path = PathUtil.getRealPath(this.rootNode, key);
        zookeeperEventListener.setPath(path);
        this.context.getWatchers().put(zookeeperEventListener.getKey(), zookeeperEventListener);
    }

    @Override
    public final void unregisterWatch(String key) {
        if (Strings.isNullOrEmpty((String)key)) {
            throw new IllegalArgumentException("key should not be blank");
        }
        if (this.context.getWatchers().containsKey(key)) {
            this.context.getWatchers().remove(key);
        }
    }

    protected void createNamespace() throws KeeperException, InterruptedException {
        this.createNamespace(ZookeeperConstants.NOTHING_DATA);
    }

    private void createNamespace(byte[] date) throws KeeperException, InterruptedException {
        if (this.rootExist) {
            return;
        }
        try {
            if (null == this.holder.getZooKeeper().exists(this.rootNode, false)) {
                this.holder.getZooKeeper().create(this.rootNode, date, this.authorities, CreateMode.PERSISTENT);
            }
            this.rootExist = true;
        }
        catch (KeeperException.NodeExistsException ex) {
            this.rootExist = true;
            return;
        }
        this.holder.getZooKeeper().exists(this.rootNode, WatcherCreator.deleteWatcher(new ZookeeperEventListener(this.rootNode){

            @Override
            public void process(WatchedEvent event) {
                BaseClient.this.rootExist = false;
            }
        }));
    }

    protected final void deleteNamespace() throws KeeperException, InterruptedException {
        try {
            this.holder.getZooKeeper().delete(this.rootNode, -1);
        }
        catch (KeeperException.NodeExistsException | KeeperException.NotEmptyException ex) {
            log.info("delete root :{}", (Object)ex.getMessage());
        }
        this.rootExist = false;
    }

    final void setAuthorities(String scheme, byte[] auth, List<ACL> authorities) {
        this.context.setScheme(scheme);
        this.context.setAuth(auth);
        this.authorities = authorities;
    }

    protected List<ACL> getAuthorities() {
        return this.authorities;
    }

    protected void setRootExist(boolean rootExist) {
        this.rootExist = rootExist;
    }

    protected Holder getHolder() {
        return this.holder;
    }

    protected void setHolder(Holder holder) {
        this.holder = holder;
    }

    protected void setRootNode(String rootNode) {
        this.rootNode = rootNode;
    }

    protected String getRootNode() {
        return this.rootNode;
    }

    protected BaseContext getContext() {
        return this.context;
    }
}

